/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.service.impl;

import com.bxm.localnews.dto.UserInfoDTO;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.news.domain.NewsReplyMapper;
import com.bxm.localnews.news.domain.UserReplyMapper;
import com.bxm.localnews.news.domain.VideoMapper;
import com.bxm.localnews.news.domain.VideoReplayLikeMapper;
import com.bxm.localnews.news.domain.VideoReplyMapper;
import com.bxm.localnews.news.dto.NewsReplyDTO;
import com.bxm.localnews.news.dto.VideoReplyDto;
import com.bxm.localnews.news.param.NewsReplyLikeParam;
import com.bxm.localnews.news.param.NewsReplyParam;
import com.bxm.localnews.news.param.VideoReplyLikeParam;
import com.bxm.localnews.news.param.VideoReplyListQueryParam;
import com.bxm.localnews.news.param.VideoReplyParam;
import com.bxm.localnews.news.service.NewNewsReplyService;
import com.bxm.localnews.news.service.VideoReplyFacadeService;
import com.bxm.localnews.news.service.VideoReplyService;
import com.bxm.localnews.news.vo.NewsReply;
import com.bxm.localnews.news.vo.UserReply;
import com.bxm.localnews.news.vo.Video;
import com.bxm.localnews.news.vo.VideoReplayLike;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class VideoReplyServiceImpl
extends BaseService
implements VideoReplyService,
VideoReplyFacadeService {
    private final VideoReplyMapper videoReplyMapper;
    private final RedisListAdapter redisListAdapter;
    private final VideoMapper videoMapper;
    private final VideoReplayLikeMapper videoReplayLikeMapper;
    private final UserIntegrationService userIntegrationService;
    private final NewsReplyMapper newsReplyMapper;
    private final NewNewsReplyService newsReplyService;
    private final UserReplyMapper userReplyMapper;

    @Autowired
    public VideoReplyServiceImpl(VideoReplyMapper videoReplyMapper, RedisListAdapter redisListAdapter, VideoMapper videoMapper, VideoReplayLikeMapper videoReplayLikeMapper, UserIntegrationService userIntegrationService, NewsReplyMapper newsReplyMapper, NewNewsReplyService newsReplyService, UserReplyMapper userReplyMapper) {
        this.videoReplyMapper = videoReplyMapper;
        this.redisListAdapter = redisListAdapter;
        this.videoMapper = videoMapper;
        this.videoReplayLikeMapper = videoReplayLikeMapper;
        this.userIntegrationService = userIntegrationService;
        this.newsReplyMapper = newsReplyMapper;
        this.newsReplyService = newsReplyService;
        this.userReplyMapper = userReplyMapper;
    }

    @Override
    public PageWarper<VideoReplyDto> queryByPageSize(VideoReplyListQueryParam param) {
        NewsReplyParam newsReplyParam = new NewsReplyParam();
        newsReplyParam.setPageNum(param.getPageNum());
        newsReplyParam.setPageSize(param.getPageSize());
        newsReplyParam.setUserId(param.getUserId());
        newsReplyParam.setNewsId(param.getVideoId());
        ArrayList<VideoReplyDto> videoReplyDtoList = new ArrayList<VideoReplyDto>();
        PageWarper newsReplyDTOPageWarper = new PageWarper(this.newsReplyMapper.queryVideoReplyByPageSize(newsReplyParam));
        List newsReplyDTOList = newsReplyDTOPageWarper.getList();
        for (NewsReplyDTO newsReplyDTO : newsReplyDTOList) {
            NewsReply sourceReply;
            VideoReplyDto videoReplyDto = new VideoReplyDto();
            if (this.isLike(newsReplyDTO.getUserId(), newsReplyDTO.getId())) {
                videoReplyDto.setIsLike(Integer.valueOf(1));
            }
            videoReplyDto.setAddTime(newsReplyDTO.getAddTime());
            videoReplyDto.setComment(newsReplyDTO.getReplyContent());
            videoReplyDto.setDeleleFlag((int)newsReplyDTO.getDeleteFlag());
            videoReplyDto.setId(newsReplyDTO.getId());
            videoReplyDto.setLikeCount(newsReplyDTO.getLikeCount());
            videoReplyDto.setUserId(newsReplyDTO.getUserId());
            videoReplyDto.setUserImg(newsReplyDTO.getHeadImg());
            videoReplyDto.setUserName(newsReplyDTO.getUserNickname());
            if (newsReplyDTO.getParentId() != 0L && null != (sourceReply = this.newsReplyMapper.selectByPrimaryKey(newsReplyDTO.getParentId()))) {
                VideoReplyDto vSourceReply = new VideoReplyDto();
                if (this.isLike(sourceReply.getUserId(), sourceReply.getId())) {
                    vSourceReply.setIsLike(Integer.valueOf(1));
                }
                vSourceReply.setAddTime(sourceReply.getAddTime());
                vSourceReply.setComment(sourceReply.getReplyContent());
                vSourceReply.setDeleleFlag((int)sourceReply.getDeleteFlag());
                vSourceReply.setId(sourceReply.getId());
                vSourceReply.setLikeCount(sourceReply.getLikeCount());
                vSourceReply.setUserId(sourceReply.getUserId());
                vSourceReply.setUserImg(sourceReply.getHeadImg());
                vSourceReply.setUserName(sourceReply.getUserNickname());
                videoReplyDto.setSourceReply(vSourceReply);
            }
            videoReplyDtoList.add(videoReplyDto);
        }
        return new PageWarper(videoReplyDtoList);
    }

    private boolean isLike(Long userId, Long replyId) {
        VideoReplayLike videoReplayLike = this.videoReplayLikeMapper.selectByModel(new VideoReplayLike(replyId, userId));
        return null != videoReplayLike;
    }

    @Override
    public Message replyVideo(VideoReplyParam videoReplyParam) {
        Video video;
        UserInfoDTO userInfoDTO;
        NewsReply newsReplyDb;
        if (!this.checkReplyParam(videoReplyParam)) {
            return Message.build((boolean)false, (String)"\u53c2\u6570\u9a8c\u8bc1\u9519\u8bef");
        }
        NewsReply newsReply = new NewsReply();
        newsReply.setType(Byte.valueOf((byte)2));
        newsReply.setNewsId(videoReplyParam.getVideoId());
        newsReply.setRootId(Long.valueOf(0L));
        newsReply.setParentId(Long.valueOf(0L));
        newsReply.setLevel(Byte.valueOf((byte)0));
        newsReply.setStatus(Byte.valueOf((byte)1));
        newsReply.setLikeCount(Integer.valueOf(0));
        newsReply.setId(this.nextSequence());
        newsReply.setReplyContent(videoReplyParam.getComment());
        if (videoReplyParam.getReplyId() != null && (newsReplyDb = this.newsReplyMapper.selectByPrimaryKey(videoReplyParam.getReplyId())) != null) {
            UserInfoDTO userInfoDTO2 = this.userIntegrationService.getUserInfo(newsReplyDb.getUserId());
            if (null != userInfoDTO2) {
                newsReply.setParentUserNickname(userInfoDTO2.getNickname());
                newsReply.setParentUserId(userInfoDTO2.getId());
                newsReply.setParentHeadImg(userInfoDTO2.getHeadImg());
            }
            newsReply.setParentId(newsReplyDb.getId());
            newsReply.setRootId(newsReplyDb.getRootId());
            Byte level = newsReplyDb.getLevel();
            if (level == 0) {
                newsReply.setLevel(Byte.valueOf((byte)1));
                newsReply.setRootId(newsReplyDb.getId());
            } else {
                newsReply.setLevel(Byte.valueOf((byte)2));
                newsReply.setRootId(newsReplyDb.getRootId());
            }
        }
        if (null != (userInfoDTO = this.userIntegrationService.getUserInfo(videoReplyParam.getUserId()))) {
            newsReply.setUserNickname(userInfoDTO.getNickname());
            newsReply.setUserId(userInfoDTO.getId());
            newsReply.setHeadImg(userInfoDTO.getHeadImg());
        }
        int count = this.newsReplyMapper.insertSelective(newsReply);
        UserReply userReply = new UserReply();
        BeanUtils.copyProperties((Object)newsReply, (Object)userReply);
        this.userReplyMapper.insertSelective(userReply);
        if (count > 0 && null != (video = this.videoMapper.selectByPrimaryKey(videoReplyParam.getVideoId()))) {
            Video videoUp = new Video();
            videoUp.setId(videoReplyParam.getVideoId());
            videoUp.setCommentCount(Long.valueOf(video.getCommentCount() + 1L));
            this.videoMapper.updateByPrimaryKeySelective(videoUp);
        }
        return Message.build((boolean)true);
    }

    private boolean checkReplyParam(VideoReplyParam videoReplyParam) {
        return null != videoReplyParam.getUserId() && null != videoReplyParam.getComment() && null != videoReplyParam.getVideoId();
    }

    @Override
    public Message produceVideoReplyLike(VideoReplyLikeParam videoReplyLikeParam) {
        if (!this.checkLikeParam(videoReplyLikeParam)) {
            return Message.build((boolean)false, (String)"\u53c2\u6570\u9a8c\u8bc1\u9519\u8bef");
        }
        NewsReplyLikeParam newsReplyLikeParam = new NewsReplyLikeParam();
        newsReplyLikeParam.setReplyId(videoReplyLikeParam.getReplyId());
        newsReplyLikeParam.setType(videoReplyLikeParam.getType());
        newsReplyLikeParam.setUserId(videoReplyLikeParam.getUserId());
        return this.newsReplyService.doProduceNewsReplyLike(newsReplyLikeParam);
    }

    @Override
    @Async
    public void videoReplyLikeConsume() {
    }

    private int generatorLikeCount(int type, int likeCount) {
        if (0 == type) {
            if (likeCount > 0) {
                --likeCount;
            }
        } else {
            ++likeCount;
        }
        return likeCount;
    }

    private int saveReplyLiKeRecord(Long replyId, Long userId, int type) {
        int count = 0;
        VideoReplayLike videoReplayLike = this.videoReplayLikeMapper.selectByModel(new VideoReplayLike(replyId, userId));
        if (type == 1) {
            if (null == videoReplayLike) {
                VideoReplayLike videoReplayLikeNew = new VideoReplayLike();
                videoReplayLikeNew.setAddTime(new Date());
                videoReplayLikeNew.setId(this.nextSequence());
                videoReplayLikeNew.setReplyId(replyId);
                videoReplayLikeNew.setUserId(userId);
                count = this.videoReplayLikeMapper.insert(videoReplayLikeNew);
            }
        } else if (null != videoReplayLike) {
            count = this.videoReplayLikeMapper.deleteByPrimaryKey(videoReplayLike.getId());
        }
        return count;
    }

    @Override
    @Async
    public void triggerUpdateInfo(Long userId, String nickname, String headImg) {
    }

    private boolean checkLikeParam(VideoReplyLikeParam videoReplyLikeParam) {
        return null != videoReplyLikeParam.getReplyId() && null != videoReplyLikeParam.getUserId();
    }
}

