/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.strategy;

import com.bxm.localnews.integration.MissionIntegrationService;
import com.bxm.localnews.news.domain.NewsRecordMapper;
import com.bxm.localnews.news.dto.NewsCompleTaskDTO;
import com.bxm.localnews.news.param.ExecGoldCalParam;
import com.bxm.localnews.news.strategy.AbstractGoldenStrategy;
import com.bxm.localnews.news.vo.NewsGoldMeta;
import com.bxm.localnews.news.vo.NewsRecord;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class GoldCalculatorOfVideo
extends AbstractGoldenStrategy {
    @Resource
    private NewsRecordMapper newsRecordMapper;
    @Resource
    private MissionIntegrationService missionIntegrationService;

    @Override
    public void calculator(ExecGoldCalParam execGoldCalParam) {
        NewsCompleTaskDTO reward;
        Long newsId = execGoldCalParam.getNewsId();
        Long userId = execGoldCalParam.getUserId();
        Integer viewTime = execGoldCalParam.getViewTime();
        String advertShow = execGoldCalParam.getAdvertShow();
        NewsGoldMeta newsGoldMeta = execGoldCalParam.getNewsGoldMeta();
        NewsRecord nRecord = execGoldCalParam.getnRecord();
        byte goldType = 1;
        if (this.checkLegalWithFlag(this.viewTimeFlag, this.advertShowFlag, execGoldCalParam.isSuspendFlag()) && (reward = this.missionIntegrationService.compleTask(userId, "TASK_VIDEO_READ", newsId.toString())) != null) {
            goldType = 2;
            nRecord.setGetGoldTime(new Date());
            nRecord.setIntervalNum(this.randomInterval);
            newsGoldMeta.setGoldNum(reward.getGoldNum().intValue());
            newsGoldMeta.setTotalGold(reward.getTotalGold());
            newsGoldMeta.setTaskName(reward.getTaskName());
        }
        nRecord.setGetGold(Byte.valueOf(goldType));
        nRecord.setUserId(userId);
        this.newsRecordMapper.updateByPrimaryKeySelective(nRecord);
        newsGoldMeta.setGoldType(goldType);
    }

    @Override
    public boolean support(int newsType) {
        return 3 == newsType;
    }

    private boolean checkLegalWithFlag(boolean viewTimeFlag, boolean advertShowFlag, boolean isSuspendFlag) {
        return viewTimeFlag && advertShowFlag && isSuspendFlag;
    }
}

