package com.bxm.localnews.news.service.impl;

import com.bxm.localnews.common.config.NewsProperties;
import com.bxm.localnews.news.domain.UserKindMapper;
import com.bxm.localnews.news.param.UserKindExample;
import com.bxm.localnews.news.service.UserKindService;
import com.bxm.localnews.news.vo.UserKind;
import com.bxm.newidea.component.vo.Message;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
public class UserKindServiceImpl implements UserKindService {

    private UserKindMapper userKindMapper;

    private NewsProperties newsProperties;

    @Autowired
    public UserKindServiceImpl(UserKindMapper userKindMapper,NewsProperties newsProperties) {
        this.userKindMapper = userKindMapper;
        this.newsProperties = newsProperties;
    }

    @Override
    public Message copyKinds(Long fromUserId, Long toUserId) {
        return Message.build(this.userKindMapper.copyKinds(fromUserId, toUserId));
    }

    @Override
    public void resortKinds(Long userId, Integer[] kindIds, String firstOpenType) {
        this.userKindMapper.deleteByExample(new UserKindExample() {{
            this.createCriteria().andUserIdEqualTo(userId);
        }});
        if ("1".equals(firstOpenType)) {
            Integer[] fixedKindIds = getFixedKinds();
            kindIds = ArrayUtils.addAll(fixedKindIds, kindIds);
        }
        if (kindIds != null && kindIds.length > 0) {
            List<UserKind> userKindList = new ArrayList<>();
            for (int i = 0; i < kindIds.length; i++) {
                UserKind userKind = new UserKind();
                userKind.setUserId(userId);
                userKind.setKindId(kindIds[i]);
                userKind.setSortNo(i);
                userKindList.add(userKind);
            }
            this.userKindMapper.batchInsert(userKindList);
        }
    }

    /**
     * 得到固定的标签
     * @return
     */
    private Integer[] getFixedKinds(){
        Integer[] fixedKindIds = new Integer[3];
        fixedKindIds[0]=newsProperties.getRecommendKindId();
        fixedKindIds[1]=newsProperties.getVideoKindId();
        fixedKindIds[2]=newsProperties.getKnowledgeKindId();
        return fixedKindIds;
    }



}
