package com.bxm.localnews.news.service.impl;

import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.news.param.VideoViewParam;
import com.bxm.localnews.news.service.VideoViewService;
import com.bxm.localnews.news.vo.VideoView;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.vo.Message;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VideoViewServiceImpl extends BaseService implements VideoViewService {

    @Autowired
    private RedisListAdapter redisListAdapter;

    @Override
    public Message produceVideoView(VideoViewParam videoViewParam) {
        if (!checkParam(videoViewParam)) {
            return Message.build(false,"参数验证失败");
        }

        KeyGenerator keyGenerator = RedisConfig.VIDEO_QUEUE.copy().setKey("videoViewQueue");

        VideoView videoView = new VideoView();
        BeanUtils.copyProperties(videoViewParam,videoView);

        redisListAdapter.leftPush(keyGenerator,videoView);

        return Message.build(true);

    }

    /**
     * 视频阅读记录时参数验证
     * @param videoViewParam
     * @return
     */
    private boolean checkParam(VideoViewParam videoViewParam){
        return null != videoViewParam.getUserId()
        && null != videoViewParam.getVideoId();
    }

}
