package com.bxm.localnews.news.strategy;

import com.bxm.localnews.common.constant.AppConst;
import com.bxm.localnews.news.param.ExecGoldCalParam;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Collection;
import java.util.List;

/**
 * 文章阅读奖励策略决策器
 */
@Service
public class GoldenStrategyContext implements InitializingBean , ApplicationContextAware {

    private Collection<GoldenStrategy> strategyList;

    private ApplicationContext applicationContext;


    public void chooseCalulator(ExecGoldCalParam execGoldCalParam) {

        Byte type = execGoldCalParam.getNews().getType();

        for(GoldenStrategy strategy:strategyList){
            if(strategy.support(type)){
                strategy.commonJudgment(execGoldCalParam);
                break;
            }
        }
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        strategyList = applicationContext.getBeansOfType(GoldenStrategy.class).values();
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}
