package com.bxm.localnews.payment.controller;

import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.payment.service.UserWithdrawService;
import com.bxm.newidea.component.util.WebUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;

/**
 * @author zhaoyadong 2019/3/11 10:07
 * @desc
 */
@Api(tags = "6-03 提现相关接口")
@RestController
@RequestMapping("api/user/withdraw")
public class UserWithdrawController {

    @Autowired
    private UserWithdrawService userWithdrawService;

    @ApiOperation(value = "6-03-1 用户发起提现", notes = "用户账户余额提现")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id"),
            @ApiImplicitParam(name = "amount", value = "提现金额")
    })
    @PostMapping("")
    public Json<BigDecimal> userWithDraw(@RequestParam("userId") Long userId, @RequestParam("amount") BigDecimal amount,
                                         BasicParam basicParam, HttpServletRequest request) {
        return userWithdrawService.userWithdraw(userId, amount, basicParam.getDevcId(),
                WebUtils.getIpAddr(request), basicParam.getPlatform());
    }
}
