package com.bxm.localnews.payment;

/**
 * 提现处理策略
 * @author liujia
 * @date 2020/05/18 21:06
 */
public enum WithdrwaStrategyEnum {
    /**
     * 一个用户仅可进行一次的提现
     * 提现后立即到账
     */
    ONCE,

    /**
     * v3.2.0: 仅可提现一次的需要审核的现金
     */
    ONCE_APPROVE,

    /**
     * 每日可提现一次
     */
    DAILY_ONCE,

    /**
     * 普通的提现策略，余额足够即可提现，会进入提现审核流程
     */
    NORMAL,

    /**
     * 直接提现，不需要审核
     */
    FLASH,
    ;

    public static WithdrwaStrategyEnum get(String name) {
        for (WithdrwaStrategyEnum value : values()) {
            if (value.name().equalsIgnoreCase(name)) {
                return value;
            }
        }

        return NORMAL;
    }
}
