package com.bxm.localnews.payment.domain;

import java.util.List;

import com.bxm.localnews.payment.param.PaymentOrderParam;
import com.bxm.localnews.payment.vo.PaymentOrder;

import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

/**
 * @author zhaoyadong 2018/12/27 21:04
 * @desc
 */
@Mapper
public interface PaymentOrderMapper {

    /**
     * 查询用户订单
     *
     * @param paymentOrderParam
     * @return
     */
    List<PaymentOrder> selectUserOrder(PaymentOrderParam paymentOrderParam);

    /**
     * 添加订单
     *
     * @param paymentOrder
     * @return
     */
    int insertSelective(PaymentOrder paymentOrder);

    /**
     * 更新订单信息
     *
     * @param paymentOrder
     * @return
     */
    int updateByPrimaryKey(PaymentOrder paymentOrder);

    /**
     * 查询用户最后一笔订单待付款信息
     *
     * @param userId
     * @param status
     * @return
     */
    PaymentOrder getUserPaymentOrderByStatus(@Param("userId") Long userId, @Param("status") Byte status);
}
