package com.bxm.localnews.payment.domain;

import com.bxm.localnews.payment.dto.PaymentOrderInfoDTO;
import com.bxm.localnews.payment.param.PaymentOrderParam;
import com.bxm.localnews.payment.vo.PaymentOrder;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author zhaoyadong 2018/12/27 21:04
 * @desc
 */
@Mapper
public interface PaymentOrderMapper {

    /**
     * 查询用户订单
     * @param paymentOrderParam
     * @return
     */
    List<PaymentOrder> selectUserOrder(PaymentOrderParam paymentOrderParam);

    /**
     * 根据支付订单编号查询订单信息
     * @param paymentNo 支付订单编号
     * @return 支付订单信息
     */
    PaymentOrder queryByNo(String paymentNo);

    /**
     * 添加订单
     * @param paymentOrder
     * @return
     */
    int insertSelective(PaymentOrder paymentOrder);

    /**
     * 更新订单信息
     * @param paymentOrder
     * @return
     */
    int updateByPrimaryKey(PaymentOrder paymentOrder);

    /**
     * 查询用户最后一笔订单待付款信息
     * @param userId    用户ID
     * @param status    订单状态
     * @param orderType 订单类型
     * @return 支付订单信息
     */
    PaymentOrder getUserPaymentOrderByStatus(@Param("userId") Long userId,
                                             @Param("status") Byte status,
                                             @Param("orderType") String orderType);
    /**
     * 按条件更新订单信息
     * @param orderNo ：订单号
     * @param status ： 更新状态
     * @return 更新条数
     */
    int updateRefundOrder(@Param("orderNo") String orderNo,@Param("status")Byte status);



    /**
     * 根据订单id查询订单信息
     * @param orderId 支付订单id
     * @return 支付订单信息
     */
    PaymentOrder queryByOrderId(Long orderId);

    /**
     * 根据订单号获取流水相关信息
     * @param orderSn ： 订单号
     * @return  ： 流水信息
     */
    PaymentOrderInfoDTO getByOrderSn(@Param("orderSn") String orderSn, @Param("status") Integer status);
}
