package com.bxm.localnews.payment.constant;

/**
 * 订单类型枚举
 * @author liujia
 * @date 2020/05/08 14:33
 */
public enum OrderTypeEnum {
    /**
     * 本地VIP，很早之前做的，估计用不到了，代码先留着
     */
    LOCAL_VIP("localVip"),

    /**
     * 福利VIP，3.2.0版本做的
     */
    WELFARE_VIP("welfareVip"),

    /**
     * 口令红包
     */
    RED_PACKET("redPacket"),

    /**
     * 商家VIP
     */
    MERCHANT_VIP("merchantVip"),
    /**
     * 用户购买商品
     */
    USER_BUY_GOODS("userBuyGoods")
    ;

    OrderTypeEnum(String code) {
        this.code = code;
    }

    private String code;

    public String getCode() {
        return code;
    }

    public static OrderTypeEnum getByCode(String code) {
        for (OrderTypeEnum value : values()) {
            if (value.getCode().equalsIgnoreCase(code)) {
                return value;
            }
        }

        return null;
    }
}
