package com.bxm.localnews.payment.constant;

/**
 * 支付状态定义
 * @author zhaoyadong 2019/1/2 22:04
 * @desc
 */
public enum PaymentStatusEnum {
    /**
     * 具体的支付状态定义
     */
    WAIT((byte) 1, "待付款", new String[]{"NOTPAY"}),
    UNDO((byte) 2, "取消付款", new String[]{"REVOKED", "CLOSED", "TRADE_CLOSED"}),
    SUCCEED((byte) 3, "付款成功", new String[]{"SUCCESS", "TRADE_SUCCESS", "TRADE_FINISHED"}),
    FAILED((byte) 4, "付款失败", new String[]{"PAYERROR"}),
    TIME_OUT((byte) 5, "支付超时", new String[]{}),
    REFUND((byte) 6, "退款成功", new String[]{"REFUND"}),
    REFUND_FAIL((byte) 7, "退款失败", new String[]{"REFUNDFAIL"}),
    REFUNDING((byte) 8, "退款中", new String[]{"REFUNDING"}),;
    private Byte type;

    private String desc;

    /**
     * 第三方中的支付状态，用于与系统的状态进行适配
     */
    private String[] thirdStateArray;

    PaymentStatusEnum(Byte type, String desc, String[] thirdStateArray) {
        this.type = type;
        this.desc = desc;
        this.thirdStateArray = thirdStateArray;
    }

    public static PaymentStatusEnum getStateByThirdState(String thridState) {
        for (PaymentStatusEnum statusEnum : PaymentStatusEnum.values()) {
            for (String thridStatuPart : statusEnum.thirdStateArray) {
                if (thridState.equals(thridStatuPart)) {
                    return statusEnum;
                }
            }
        }

        return null;
    }

    public Byte getType() {
        return type;
    }

    public void setType(Byte type) {
        this.type = type;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String[] getThirdStateArray() {
        return thirdStateArray;
    }

    public void setThirdStateArray(String[] thirdStateArray) {
        this.thirdStateArray = thirdStateArray;
    }
}
