package com.bxm.localnews.payment.constant;

/**
 * @author zhaoyadong 2019/3/28 18:17
 * @desc
 */
public enum WxWithdrawEnum {

    PROCESSING((byte) 2, "PROCESSING", "处理中"),
    SUCCESS_PAYMENT((byte) 3, "SUCCESS", "转账成功"),
    FAIL_PAYMENT((byte) 4, "FAILED", "转账失败");

    private Byte state;

    private String status;

    private String desc;

    WxWithdrawEnum(Byte state, String status, String desc) {
        this.state = state;
        this.status = status;
        this.desc = desc;
    }

    public static WxWithdrawEnum getWxWithdrawEnumByStatus(String status) {
        for (WxWithdrawEnum withdrawEnum : WxWithdrawEnum.values()) {
            if (withdrawEnum.getStatus().equals(status)) {
                return withdrawEnum;
            }
        }

        return null;
    }

    public Byte getState() {
        return state;
    }

    public void setState(Byte state) {
        this.state = state;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
