package com.bxm.localnews.payment.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

@ApiModel(description = "提现相关信息")
@Data
public class WithdrawDTO {

    @ApiModelProperty("提现列表(对应用户提现配置相关信息)")
    private List<WithdrawConfigDTO> withdrawConfigDTOList;

    @ApiModelProperty("可提现金额")
    private BigDecimal availableCash;

    @ApiModelProperty(value = "提现失败原因(上次提现失败原因，没有则为null)")
    private String failMsg;

    @ApiModelProperty("提现公告信息，如果为空则不展示公告")
    private String note;

    @ApiModelProperty("提现公告点击后跳转的协议地址，如果为空则不做跳转")
    private String noteProtocol;

    @ApiModelProperty("支付宝账号，如果为空则提示绑定")
    private String alipayAccount;
}
