package com.bxm.localnews.payment.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.experimental.Tolerate;

import java.math.BigDecimal;

@ApiModel(description = "提现选项实体")
@Data
@Builder
public class WithdrawOptionDTO {
    @ApiModelProperty("提现选项ID")
    private Long withdrawId;

    @ApiModelProperty("提现金额")
    private BigDecimal amount;

    @ApiModelProperty(value = "提现策略，详见：com.bxm.localnews.payment.WithdrwaStrategyEnum", hidden = true)
    @JsonIgnore
    private String stargy;

    @ApiModelProperty(value = "显示的位置,下标从0开始", hidden = true)
    @JsonIgnore
    private Integer index;

    @ApiModelProperty(value = "显示的优先级，相同的下标，优先级越小权重越高", hidden = true)
    @JsonIgnore
    @Builder.Default
    private Integer priority = 0;

    @Tolerate
    public WithdrawOptionDTO() {
    }
}
