package com.bxm.localnews.payment.param;

import com.bxm.newidea.component.vo.BasicParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @author liujia
 * @date 2020-08-04 21:17
 **/
@ApiModel(description = "支付宝绑定账号参数")
@Data
public class AlipayAccountBindingParam extends BasicParam {

    @ApiModelProperty("用户ID")
    @NotNull(message = "用户ID不能为空")
    private Long userId;

    @ApiModelProperty("支付宝账号")
    @NotBlank(message = "支付宝账号不能为空")
    private String account;

    @ApiModelProperty("绑定时的验证码")
    @NotBlank(message = "验证码不能为空")
    private String smsCode;

    @ApiModelProperty("支付宝中的真实姓名")
    @NotBlank(message = "真实姓名不能为空")
    private String realName;

    @ApiModelProperty("验证码对应的手机号码")
    @NotBlank(message = "手机号不能为空")
    private String phone;
}
