package com.bxm.localnews.payment.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * @author gonzo
 * @date 2020-09-01 17:49
 **/
@Data
@ApiModel(value = "商家提现打款参数")
public class MerchantWithdrawParam {

    @ApiModelProperty(value = "商户id", required = true)
    @NotNull(message = "商户id不能为空")
    private Long merchantId;

    @ApiModelProperty(value = "提现流水单号", required = true)
    @NotBlank(message = "流水单号不能为空")
    private String withdrawNo;

    @ApiModelProperty(value = "提现渠道 1: 微信 2: 支付宝", required = true)
    @NotNull(message = "提现渠道不能为空")
    private Long payChannel;

    @ApiModelProperty(value = "提现账号的真实姓名", required = true)
    @NotBlank(message = "真实姓名不能为空")
    private String realName;

    @ApiModelProperty(value = "提现账号 支付宝账号 or 微信 oid", required = true)
    @NotBlank(message = "提现账号不能为空")
    private String payAccount;

    @ApiModelProperty(value = "提现金额", required = true)
    @NotNull(message = "提现金额不能为空")
    private BigDecimal amount;

}
