package com.bxm.localnews.payment.param;

import com.bxm.localnews.payment.vo.PaymentOrder;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.ToString;
import lombok.experimental.Tolerate;

import java.math.BigDecimal;

/**
 * 支付退款参数
 * @author liujia
 * @date 2020/04/15 20:23
 */
@ToString
@Data
@Builder
public class PaymentRefundParam {
    @Tolerate
    public PaymentRefundParam() {
    }

    @ApiModelProperty(value = "订单id",required = true)
    private Long orderId;

    @ApiModelProperty(value = "付款订单编号")
    private String orderNo;

    @ApiModelProperty(value = "是否全额退款，true表示全额", required = true)
    private Boolean fullAmount = true;

    @ApiModelProperty("非全额退款时的退款金额")
    private BigDecimal refundFee;

    @ApiModelProperty("退款原因备注（作为退款订单信息保存，不显示给用户）")
    private String remark;

    @ApiModelProperty("操作人ID（运营人员ID）")
    private Long operatorId;

    @ApiModelProperty(value = "付款订单信息", hidden = true)
    private PaymentOrder payOrder;
}
