package com.bxm.localnews.payment.param;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author gonzo
 * @date 2020-09-01 17:48
 **/
@Data
@ApiModel(value = "内部发起退款参数")
public class RefundParam {

    @ApiModelProperty(value = "支付流水单号", required = true)
    private String paymentNum;

    @ApiModelProperty(value = "是否全额退款，true表示全额", required = true)
    private Boolean fullAmount = true;

    @ApiModelProperty("非全额退款时的退款金额")
    private BigDecimal refundFee;

}
