package com.bxm.localnews.payment.param;

import com.bxm.newidea.component.vo.BasicParam;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

@EqualsAndHashCode(callSuper = true)
@ApiModel(description = "用户申请提现的参数")
@Data
public class UserWithdrawParam extends BasicParam {

    @ApiModelProperty("提现选项ID,根据6-03-2接口获取")
    private Long withdrawId;

    @ApiModelProperty("提现用户ID")
    private Long userId;

    @ApiModelProperty(value = "请求IP", hidden = true)
    @JsonIgnore
    private String requestIp;
}
