package com.bxm.localnews.payment.param;

import com.bxm.newidea.component.vo.BasicParam;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import java.math.BigDecimal;
import javax.validation.constraints.NotNull;

/**
 * 用户提现接受类
 *
 * @author lowi
 * @date 2020/12/10 16:04
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class UserWithdrawV2Param extends BasicParam {

    @ApiModelProperty("提现金额")
    @DecimalMin(value = "0", message = "提现金额不能小于0.01")
    private BigDecimal money;

    @ApiModelProperty("提现用户ID")
    @NotNull(message = "用户id不能为空")
    private Long userId;

    @ApiModelProperty(value = "请求IP", hidden = true)
    @JsonIgnore
    private String requestIp;

    @ApiModelProperty("提现类型 1 微信 2 支付宝")
    @NotNull(message = "提现类型不能为空")
    @Min(value = 1, message = "提现类型 1 微信 2 支付宝")
    @Max(value = 2, message = "提现类型 1 微信 2 支付宝")
    private Integer type;
}
