package com.bxm.localnews.payment.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author zhaoyadong 2019/3/6 13:52
 * @desc
 */
@Data
@ApiModel(description = "提现订单表")
public class WithdrawFlow {

    @ApiModelProperty("id")
    private Long id;

    @ApiModelProperty("订单号")
    private String orderNo;

    @ApiModelProperty("用户id")
    private Long userId;

    @ApiModelProperty("提现渠道")
    private Long payChannel;

    @ApiModelProperty("提现账号的真实姓名")
    private String realName;

    @ApiModelProperty("提现账号")
    private String payAccount;

    @ApiModelProperty("提现金额")
    private BigDecimal amount;

    @ApiModelProperty("手续费")
    private BigDecimal fee;

    @ApiModelProperty("提现状态 1-待审核 2-支付中 3-支付成功 4-支付失败 5-延迟审核")
    private Byte state;

    @ApiModelProperty("客户端提现ip")
    private String clientIp;

    @ApiModelProperty("客户端设备号")
    private String equipment;

    @ApiModelProperty("微信付款单号")
    private String paymentNo;

    @ApiModelProperty("微信提现成功时间")
    private String paymentTime;

    @ApiModelProperty("反馈结果")
    private String remark;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("更新时间")
    private Date updateTime;

    /**
     * 提现类型：1 app提现 2 公众号提现
     */
    private Byte openIdType;
}
