package com.bxm.localnews.payment.config;

import com.github.binarywang.wxpay.config.WxPayConfig;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.WxPayService;
import com.github.binarywang.wxpay.service.impl.WxPayServiceImpl;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author zhaoyadong 2018/12/27 14:11
 * @desc
 */
@Configuration
@ConditionalOnClass(WxPayService.class)
@EnableConfigurationProperties(WxPayProperties.class)
public class WxPayConfiguration {

    private static final Logger logger = LoggerFactory.getLogger(WxPayConfiguration.class);

    private WxPayProperties properties;

    @Autowired
    public WxPayConfiguration(WxPayProperties properties) {
        this.properties = properties;
    }

    @Bean
    public WxPayService wxPayService() {
        WxPayConfig payConfig = new WxPayConfig();
        payConfig.setAppId(StringUtils.trimToNull(this.properties.getAppId()));
        payConfig.setMchId(StringUtils.trimToNull(this.properties.getMchId()));
        payConfig.setMchKey(StringUtils.trimToNull(this.properties.getMchKey()));
        payConfig.setKeyPath(StringUtils.trimToNull(this.properties.getKeyPath()));
        payConfig.setNotifyUrl(StringUtils.trimToNull(this.properties.getNotifyUrl()));
        payConfig.setTradeType(StringUtils.trimToNull(this.properties.getTradeType()));
        // 可以指定是否使用沙箱环境
        payConfig.setUseSandboxEnv(this.properties.getUseSandbox());

        WxPayService wxPayService = new WxPayServiceImpl();
        wxPayService.setConfig(payConfig);
        if (this.properties.getUseSandbox()) {
            try {
                payConfig.setMchKey(wxPayService.getSandboxSignKey());
            } catch (WxPayException e) {
                logger.error("沙箱环境开启失败：", e);
            }
        }

        return wxPayService;
    }

    @Bean
    public WxPayService wxAppletPayService(){
        WxPayConfig payConfig = new WxPayConfig();
        payConfig.setAppId(StringUtils.trimToNull(this.properties.getAppletAppId()));
        payConfig.setMchId(StringUtils.trimToNull(this.properties.getAppletMchId()));
        payConfig.setMchKey(StringUtils.trimToNull(this.properties.getAppletMchKey()));
        payConfig.setKeyPath(StringUtils.trimToNull(this.properties.getAppletKeyPath()));
        payConfig.setNotifyUrl(StringUtils.trimToNull(this.properties.getNotifyUrl()));
        payConfig.setTradeType(StringUtils.trimToNull(this.properties.getAppletTradeType()));
        // 可以指定是否使用沙箱环境
        payConfig.setUseSandboxEnv(this.properties.getAppletUseSandbox());

        WxPayService wxPayService = new WxPayServiceImpl();
        wxPayService.setConfig(payConfig);
        if (this.properties.getUseSandbox()) {
            try {
                payConfig.setMchKey(wxPayService.getSandboxSignKey());
            } catch (WxPayException e) {
                logger.error("沙箱环境开启失败：", e);
            }
        }

        return wxPayService;
    }
}
