package com.bxm.localnews.payment.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * @author zhaoyadong 2018/12/27 14:04
 * @desc
 */
@ConfigurationProperties("payment.weixin.pay")
@Data
public class WxPayProperties {

    /**
     * appId
     */
    private String appId;

    /**
     * 小程序appid
     */
    private String appletAppId;

    /**
     * 商户号
     */
    private String mchId;

    /**
     * 小程序商户号
     */
    private String appletMchId;

    /**
     * 商户密钥
     */
    private String mchKey;

    /**
     * 小程序商户密钥
     */
    private String appletMchKey;

    /**
     * 证书路径
     */
    private String keyPath;

    /**
     * 小程序证书路径
     */
    private String appletKeyPath;

    /**
     * 微信支付回调地址
     */
    private String notifyUrl;

    /**
     * 支付场景信息
     */
    private String sceneInfo;

    /**
     * 商品描述
     */
    private String body;

    /**
     * 交易类型
     */
    private String tradeType;

    /**
     * 小程序交易类型
     */
    private String appletTradeType;

    /**
     * 是否使用沙箱环境
     */
    private Boolean useSandbox = Boolean.FALSE;

    /**
     * 小程序是否使用沙箱环境
     */
    private Boolean appletUseSandbox = Boolean.FALSE;

    /**
     * 企业付款描述信息
     */
    private String desc;

    /**
     * 未实名认证返回消息
     */
    private String untFailMsg;

    private String otherFailMsg;
}
