package com.bxm.localnews.payment.request;

import com.github.binarywang.wxpay.bean.request.BaseWxPayRequest;
import com.thoughtworks.xstream.annotations.XStreamAlias;

import lombok.*;

/**
 * @author zhaoyadong 2019/3/28 17:09
 * @desc
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Builder(builderMethodName = "newBuilder")
@NoArgsConstructor
@AllArgsConstructor
@XStreamAlias("xml")
public class WxPayQueryWithdrawRequest extends BaseWxPayRequest {

    /**
     * 商户订单号
     * 商户订单号，需保持唯一性
     * (只能是字母或者数字，不能包含有其他字符)
     */
    @XStreamAlias("partner_trade_no")
    private String partnerTradeNo;

    @Override
    protected String[] getIgnoredParamsForSign() {
        return new String[]{"sign_type"};
    }

    @Override
    protected void checkConstraints() {

    }

    @Override
    public String getAppid() {
        return this.appid;
    }

    @Override
    public void setAppid(String appid) {
        this.appid = appid;
    }
}
