package com.bxm.localnews.payment.service;

import com.bxm.localnews.payment.constant.PayTypeEnum;
import com.bxm.localnews.payment.vo.PaymentOrder;
import com.bxm.localnews.payment.vo.PaymentOrderDetail;

/**
 * @author zhaoyadong 2019/1/2 9:52
 * @desc
 */
public interface PayModeService {

    /**
     * 当前支付模式对应的支付类型枚举
     *
     * @return 返回当前支持的支付类型
     */
    PayTypeEnum support();

    /**
     * 下单
     *
     * @param paymentOrderDetail
     */
    void create(PaymentOrderDetail paymentOrderDetail);

    /**
     * 查看订单
     *
     * @param paymentOrder
     */
    void query(PaymentOrder paymentOrder);

    /**
     * 支付回调
     *
     * @param data
     */
    String callBack(String data);
}
