package com.bxm.localnews.payment.service;

import java.math.BigDecimal;

import com.bxm.localnews.common.vo.Json;
import com.bxm.newidea.component.vo.Message;

/**
 * @author zhaoyadong 2019/3/11 10:24
 * @desc
 */
public interface UserWithdrawService {

    /**
     * 用户发起提现
     *
     * @param userId
     * @param amount
     * @param equipment
     * @param ip        客户端ip
     * @return
     */
    Json<BigDecimal> userWithdraw(Long userId, BigDecimal amount, String equipment, String ip, Integer platform);

    /**
     * 小程序提现
     *
     * @param userId 用户id
     * @param openId 小程序的openId
     * @param amount 提现金额
     * @param devcId 设备号
     * @param ip     客户端ip
     * @return
     */
    Message appletUserWithdraw(Long userId, String openId, BigDecimal amount, String devcId, String ip);
}
