package com.bxm.localnews.payment.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * @author zhaoyadong 2018/12/27 14:04
 * @desc
 */
@ConfigurationProperties("payment.weixin.pay")
@Data
public class WxPayProperties {

    /**
     * appId
     */
    private String appId;

    /**
     * 商户号
     */
    private String mchId;

    /**
     * 商户密钥
     */
    private String mchKey;

    /**
     * 证书路径
     */
    private String keyPath;

    /**
     * 交易类型
     */
    private String tradeType;

    /**
     * 是否使用沙箱环境
     */
    private Boolean useSandbox = Boolean.FALSE;

    /**
     * ======================================================
     * 小程序证书路径
     */
    private String appletKeyPath;

    /**
     * 小程序商户号
     */
    private String appletMchId;

    /**
     * 小程序appid
     */
    private String appletAppId;

    /**
     * 小程序商户密钥
     */
    private String appletMchKey;

    /**
     * 交易类型
     */
    private String appletTradeType;

    /**
     * 小程序是否使用沙箱环境
     */
    private Boolean appletUseSandbox = Boolean.FALSE;

    /**
     * ======================================================
     * 提现商户号证书路径
     */
    private String withdrawKeyPath;

    /**
     * 提现商户号商户号
     */
    private String withdrawMchId;

    /**
     * 提现商户号appid
     */
    private String withdrawAppId;

    /**
     * 提现商户号商户密钥
     */
    private String withdrawMchKey;

    /**
     * 提现商户号交易类型
     */
    private String withdrawTradeType;

    /**
     * 提现商户号是否使用沙箱环境
     */
    private Boolean withdrawUseSandbox = Boolean.FALSE;

    /**
     * 公共参数
     * ====================================
     * 微信支付回调地址的path部分，需要拼接server host
     */
    private String notifyPath = "/api/notify/wechat";

    /**
     * 微信退款回调地址path部分，需要拼接server host
     */
    private String refundNotifyPath = "/api/notify/wx/refund";
    /**
     * 支付场景信息
     */
    private String sceneInfo;

    /**
     * 商品描述
     */
    private String body;

    /**
     * 企业付款描述信息
     */
    private String desc;

    /**
     * 未实名认证返回消息
     */
    private String untFailMsg;

    /**
     * 提现失败的提示信息
     */
    private String otherFailMsg;

    /**
     * 公众号的appid
     */
    private String withdrawMpAppId;
}
