package com.bxm.localnews.payment.order.impl;

import com.bxm.localnews.payment.constant.OrderTypeEnum;
import com.bxm.localnews.payment.order.OrderProcesser;
import com.bxm.localnews.payment.param.UserOrderParam;
import com.bxm.localnews.payment.vo.PaymentOrder;
import com.bxm.newidea.component.vo.Message;
import lombok.extern.slf4j.Slf4j;

import java.math.BigDecimal;

/**
 * 默认的订单处理
 * @author liujia
 * @date 2020/05/08 15:32
 */
@Slf4j
public class DefaultOrderProcesser implements OrderProcesser {
    @Override
    public OrderTypeEnum match() {
        return null;
    }

    @Override
    public Message preCheck(UserOrderParam param) {
        return Message.build();
    }

    @Override
    public BigDecimal price(UserOrderParam param) {
        return BigDecimal.ZERO;
    }

    @Override
    public Message afterPayment(PaymentOrder paymentOrder) {
        return Message.build();
    }

    @Override
    public Message afterRefund(PaymentOrder paymentOrder) {
        return Message.build();
    }
}
