package com.bxm.localnews.payment.pay;

import com.bxm.localnews.payment.constant.PayTypeEnum;
import com.bxm.localnews.payment.param.PaymentRefundParam;
import com.bxm.localnews.payment.vo.PaymentOrder;
import com.bxm.localnews.payment.vo.PaymentOrderDetail;
import com.bxm.newidea.component.vo.Message;

/**
 * 支付相关的方法定义
 * @author zhaoyadong 2019/1/2 9:52
 * @desc
 */
public interface PayModeService {

    /**
     * 当前支付模式对应的支付类型枚举
     * @return 返回当前支持的支付类型
     */
    PayTypeEnum support();

    /**
     * 下单
     * @param paymentOrderDetail
     */
    void create(PaymentOrderDetail paymentOrderDetail);

    /**
     * 查看订单
     * @param paymentOrder
     */
    void query(PaymentOrder paymentOrder);

    /**
     * 支付回调
     * @param data
     */
    String callBack(String data);
    /**
     * 发起申请退款(全额退还)
     * @param param 支付订单信息
     * @return 回调的处理结果，返回到第三方
     */
    Message submitRefund(PaymentRefundParam param);

    /**
     * 退款结果回调函数
     * @param callbackRequest 回调结果字符串
     * @return 回调处理结果
     */
    String execRefundCallback(String callbackRequest);
}
