package com.bxm.localnews.payment.service;

import com.bxm.localnews.payment.constant.WithdrawAccountType;
import com.bxm.localnews.payment.param.AlipayAccountBindingParam;
import com.bxm.localnews.payment.vo.WithdrawAccountVO;
import com.bxm.newidea.component.vo.Message;

import java.util.Optional;

/**
 * 提现账户service
 * @author gonzo
 * @date 2020-08-10 19:24
 **/
public interface PaymentWithdrawAccountService {
    /**
     * 绑定 or 更新支付宝提现账号
     * @param param 支付宝提现账号请求参数
     * @return 操作结果
     */
    Message bindOrUpdateAlipayAccount(AlipayAccountBindingParam param);

    /**
     * 根据提现账号类型，获取对应的提现账号
     * @param type @{@link WithdrawAccountType}
     * @param userId userId
     * @return 提现账号
     */
    Optional<WithdrawAccountVO> getPaymentAccount(Byte type, Long userId);

}
