package com.bxm.localnews.payment.withdraw.filter;

import com.bxm.localnews.payment.config.PayProperties;
import com.bxm.localnews.payment.domain.PaymentBlackMapper;
import com.bxm.localnews.payment.entity.PaymentBlackBean;
import com.bxm.localnews.payment.withdraw.WithdrawContext;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.component.vo.Message;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 提现黑名单账号，判断如果是黑名单账号则不允许提现
 *
 * @author liujia
 * @date 12/19/20 2:15 PM
 **/
@Component
@Slf4j
@AllArgsConstructor
public class BlackAccountWithdrawFilter extends AbstractWithdrawFilter {

    private PaymentBlackMapper paymentBlackMapper;

    private PayProperties payProperties;

    @Override
    public Message run(WithdrawContext context) {
        if (Boolean.FALSE.equals(payProperties.getEnableBlack())) {
            return Message.build();
        }

        PaymentBlackBean paymentBlackBean = paymentBlackMapper.selectByUserId(context.getUserId());
        if (null == paymentBlackBean) {
            return Message.build();
        }

        if (StringUtils.isBlank(paymentBlackBean.getTips())) {
            paymentBlackBean.setTips("暂时不支持提现申请");
        }

        return Message.build(false, paymentBlackBean.getTips());
    }
}
