package com.bxm.localnews.payment.withdraw.strategy;

import com.bxm.localnews.payment.WithdrwaStrategyEnum;
import com.bxm.localnews.payment.withdraw.WithdrawContext;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.vo.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import static com.bxm.localnews.common.constant.RedisConfig.WITHDRAW_ONCE_APPROVE_RECORD;
import static com.bxm.localnews.payment.WithdrwaStrategyEnum.ONCE_APPROVE;

/**
 * 一个用户只有一次机会的提现，但是提现会进入审核流程
 *
 * @author liujia
 */
@Component
public class OnceApproveWithdrawStrategy extends AbstractWithdrawStrategy {

    private final RedisSetAdapter redisSetAdapter;

    @Autowired
    public OnceApproveWithdrawStrategy(RedisSetAdapter redisSetAdapter) {
        this.redisSetAdapter = redisSetAdapter;
    }

    @Override
    public WithdrwaStrategyEnum match() {
        return ONCE_APPROVE;
    }

    private KeyGenerator buildKey(Long userId) {
        return WITHDRAW_ONCE_APPROVE_RECORD.copy().appendKey(userId % 10);
    }

    @Override
    public Message execWithdraw(WithdrawContext context) {
        Message message = submitApprove(context);

        if (message.isSuccess()) {
            redisSetAdapter.add(buildKey(context.getUserId()), context.getUserId());
        }

        return message;
    }

    @Override
    public boolean hasTimes(Long userId) {
        return !redisSetAdapter.exists(buildKey(userId), userId);
    }
}
