package com.bxm.localnews.payment.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * 证书配置的支付宝client配置
 * @author zhaoyadong 2019/1/2 13:54
 * @desc
 */
@Data
@Component
@ConfigurationProperties("payment.ali.pay.cert")
public class AlipayCertProperties {

    /**
     * appId
     */
    private String appId;

    /**
     * 支付宝请求网关
     */
    private String gateWayUrl;

    /**
     * 应用私钥
     */
    private String privateKey;

    /**
     * json
     */
    private String format;

    /**
     * 编码格式
     */
    private String charset;

    /**
     * 签名类型
     */
    private String signType;

    /**
     * 应用公钥证书路径 文件绝对路径
     */
    private String certPath;

    /**
     *  支付宝 CA 根证书文件路径（alipay_root_cert_path 文件绝对路径）
     */
    private String rootCertPath;

    /**
     * 支付宝公钥证书文件路径（alipay_cert_path 文件绝对路径）
     */
    private String alipayPublicCertPath;

    /**
     * 接口内容加密方式
     */
    private String apiSignKey = "XYf+LVrCJXsEgiUxQOJXSA==";
}
