package com.bxm.localnews.payment.config;

import com.bxm.localnews.base.service.BaseUrlFacadeService;
import com.github.binarywang.wxpay.config.WxPayConfig;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.WxPayService;
import com.github.binarywang.wxpay.service.impl.WxPayServiceImpl;
import lombok.AllArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import static org.apache.commons.lang3.StringUtils.join;
import static org.apache.commons.lang3.StringUtils.trimToNull;

/**
 * @author zhaoyadong 2018/12/27 14:11
 * @desc
 */
@Configuration
@ConditionalOnClass(WxPayService.class)
@EnableConfigurationProperties(WxPayProperties.class)
@AllArgsConstructor
public class WxPayConfiguration {

    private static final Logger logger = LoggerFactory.getLogger(WxPayConfiguration.class);

    private WxPayProperties properties;

    private final BaseUrlFacadeService baseUrlFacadeService;


    /**
     * 微信H5支付，用于收款
     */
    @Bean
    public WxPayService wxPayService() {
        WxPayConfig payConfig = new WxPayConfig();
        payConfig.setAppId(trimToNull(properties.getAppId()));
        payConfig.setMchId(trimToNull(properties.getMchId()));
        payConfig.setMchKey(trimToNull(properties.getMchKey()));
        payConfig.setKeyPath(trimToNull(properties.getKeyPath()));
        payConfig.setNotifyUrl(trimToNull(join(baseUrlFacadeService.getServerHostBaseUrl(),
                properties.getNotifyPath())));
        payConfig.setTradeType(trimToNull(properties.getTradeType()));
        // 可以指定是否使用沙箱环境
        payConfig.setUseSandboxEnv(properties.getUseSandbox());

        WxPayService wxPayService = new WxPayServiceImpl();
        wxPayService.setConfig(payConfig);
        if (properties.getUseSandbox()) {
            try {
                payConfig.setMchKey(wxPayService.getSandboxSignKey());
            } catch (WxPayException e) {
                logger.error("沙箱环境开启失败：", e);
            }
        }

        return wxPayService;
    }

    /**
     * 微信提现用的账号信息
     * @return 微信提现服务信息
     */
    @Bean
    public WxPayService wxWithdrawPayService() {
        WxPayConfig payConfig = new WxPayConfig();
        payConfig.setAppId(trimToNull(properties.getWithdrawAppId()));
        payConfig.setMchId(trimToNull(properties.getWithdrawMchId()));
        payConfig.setMchKey(trimToNull(properties.getWithdrawMchKey()));
        payConfig.setKeyPath(trimToNull(properties.getWithdrawKeyPath()));
        payConfig.setNotifyUrl(trimToNull(join(baseUrlFacadeService.getServerHostBaseUrl(),
                properties.getNotifyPath())));
        payConfig.setTradeType(trimToNull(properties.getWithdrawTradeType()));
        // 可以指定是否使用沙箱环境
        payConfig.setUseSandboxEnv(properties.getWithdrawUseSandbox());

        WxPayService wxPayService = new WxPayServiceImpl();
        wxPayService.setConfig(payConfig);
        if (properties.getWithdrawUseSandbox()) {
            try {
                payConfig.setMchKey(wxPayService.getSandboxSignKey());
            } catch (WxPayException e) {
                logger.error("沙箱环境开启失败：", e);
            }
        }

        return wxPayService;
    }

    /**
     * 微信小程序支付
     * @return
     */
    @Bean
    public WxPayService wxAppletPayService() {
        WxPayConfig payConfig = new WxPayConfig();
        payConfig.setAppId(trimToNull(properties.getAppletAppId()));
        payConfig.setMchId(trimToNull(properties.getAppletMchId()));
        payConfig.setMchKey(trimToNull(properties.getAppletMchKey()));
        payConfig.setKeyPath(trimToNull(properties.getAppletKeyPath()));
        payConfig.setNotifyUrl(trimToNull(join(baseUrlFacadeService.getServerHostBaseUrl(),
                properties.getNotifyPath())));
        payConfig.setTradeType(trimToNull(properties.getAppletTradeType()));
        // 可以指定是否使用沙箱环境
        payConfig.setUseSandboxEnv(properties.getAppletUseSandbox());

        WxPayService wxPayService = new WxPayServiceImpl();
        wxPayService.setConfig(payConfig);
        if (properties.getUseSandbox()) {
            try {
                payConfig.setMchKey(wxPayService.getSandboxSignKey());
            } catch (WxPayException e) {
                logger.error("沙箱环境开启失败：", e);
            }
        }

        return wxPayService;
    }
}
