/*
 * Copyright 2017 bianxianmao.com All right reserved. This software is the confidential and proprietary information of
 * bianxianmao.com ("Confidential Information"). You shall not disclose such Confidential Information and shall use it
 * only in accordance with the terms of the license agreement you entered into with bianxianmao.com.
 */
package com.bxm.localnews.payment.order.impl;

import com.bxm.localnews.payment.constant.OrderTypeEnum;
import com.bxm.localnews.payment.order.OrderProcesser;
import com.bxm.localnews.payment.param.UserOrderParam;
import com.bxm.localnews.payment.vo.PaymentOrder;
import com.bxm.newidea.component.vo.Message;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;

/**
 * @author jieliGG
 * @date 2020/8/24 22:41
 * 商户购买权益
 **/
@Component
public class MerchantVipProcesser implements OrderProcesser {
    //商户购买商品传递订单价格
    private ThreadLocal<BigDecimal> price = new ThreadLocal<>();
    @Override
    public OrderTypeEnum match() {
        return OrderTypeEnum.MERCHANT_VIP;
    }

    @Override
    public Message preCheck(UserOrderParam param) {
        return  Message.build();
    }

    @Override
    public BigDecimal price(UserOrderParam param) {
        return price.get();
    }

    @Override
    public Message afterPayment(PaymentOrder paymentOrder) {
        return  Message.build();
    }

    @Override
    public Message afterRefund(PaymentOrder paymentOrder) {
        return  Message.build();
    }

    public ThreadLocal<BigDecimal> getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price.set(price);
    }
}
