package com.bxm.localnews.payment.pay.wechat;

import com.bxm.localnews.payment.constant.PayTypeEnum;
import com.bxm.localnews.payment.pay.PayModeService;
import com.bxm.localnews.payment.vo.PaymentOrder;
import com.bxm.localnews.payment.vo.PaymentOrderDetail;
import com.github.binarywang.wxpay.bean.order.WxPayMpOrderResult;
import org.springframework.stereotype.Component;

@Component
public class WechatJsApiPayModeService extends AbstractWechatPayModeService {
    @Override
    public PayTypeEnum support() {
        return PayTypeEnum.WX_JS_AY;
    }

    @Override
    public void create(PaymentOrderDetail paymentOrderDetail) {
        WxPayMpOrderResult jsApiOrder = wxWithdrawProxyService.createJsApiOrder(paymentOrderDetail);

        paymentOrderDetail.setAppId(jsApiOrder.getAppId());
        paymentOrderDetail.setNonceStr(jsApiOrder.getNonceStr());
        paymentOrderDetail.setPackageValue(jsApiOrder.getPackageValue());
        paymentOrderDetail.setPaySign(jsApiOrder.getPaySign());
        paymentOrderDetail.setSignType(jsApiOrder.getSignType());
        paymentOrderDetail.setTimeStamp(jsApiOrder.getTimeStamp());

    }
}
