package com.bxm.localnews.payment.pay.wechat;

import com.bxm.localnews.common.constant.PlatformEnum;
import com.bxm.localnews.payment.constant.PayTypeEnum;
import com.bxm.localnews.payment.constant.PaymentStatusEnum;
import com.bxm.localnews.payment.pay.PayModeService;
import com.bxm.localnews.payment.pay.PaymentOrderService;
import com.bxm.localnews.payment.vo.PaymentOrder;
import com.bxm.localnews.payment.vo.PaymentOrderDetail;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.DateUtils;
import com.gexin.fastjson.JSON;
import com.github.binarywang.wxpay.bean.notify.WxPayOrderNotifyResult;
import com.github.binarywang.wxpay.bean.order.WxPayAppOrderResult;
import com.github.binarywang.wxpay.bean.order.WxPayMwebOrderResult;
import com.github.binarywang.wxpay.bean.request.BaseWxPayRequest;
import com.github.binarywang.wxpay.bean.result.WxPayOrderQueryResult;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Objects;

/**
 * 微信支付方式相关实现
 * @author zhaoyadong 2019/1/2 11:18
 * @desc
 */
@Component
@Slf4j
public class WechatPayModeServiceImpl extends AbstractWechatPayModeService {

    private final WxWithdrawProxyService wxWithdrawProxyService;

    private final PaymentOrderService payService;

    @Autowired
    public WechatPayModeServiceImpl(WxWithdrawProxyService wxWithdrawProxyService,
                                    PaymentOrderService payService) {
        this.wxWithdrawProxyService = wxWithdrawProxyService;
        this.payService = payService;
    }

    @Override
    public PayTypeEnum support() {
        return PayTypeEnum.WX_PAY;
    }

    @Override
    public void create(PaymentOrderDetail paymentOrderDetail) {
        if (Objects.equals(PlatformEnum.APPLET.getCode(), paymentOrderDetail.getPlatform())) {
            //APP、小程序支付
            WxPayAppOrderResult result = wxWithdrawProxyService.createAppOrder(paymentOrderDetail);
            paymentOrderDetail.setLink(JSON.toJSONString(result));
        } else {
            //H5支付
            WxPayMwebOrderResult webOrderResult = wxWithdrawProxyService.createWebOrder(paymentOrderDetail);
            if (Objects.nonNull(webOrderResult)) {
                paymentOrderDetail.setLink(webOrderResult.getMwebUrl());
            }
        }
    }
}
