package com.bxm.localnews.payment.service.impl;

import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.payment.domain.CashFlowMapper;
import com.bxm.localnews.payment.domain.WithdrawMapper;
import com.bxm.localnews.payment.service.MoneyChangeService;
import com.bxm.localnews.payment.vo.MoneyChange;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;

/**
 * @author zhaoyadong 2019/4/17 14:02
 * @desc
 */
@Service
@Slf4j
public class MoneyChangeServiceImpl implements MoneyChangeService {

    @Resource
    private WithdrawMapper withdrawMapper;

    @Resource
    private UserIntegrationService userIntegrationService;

    @Resource
    private CashFlowMapper cashFlowMapper;

    @Resource
    private RedisStringAdapter redisStringAdapter;

    @Override
    public MoneyChange changeMoneyStatisticsByHour(String startTime, String endTime) {

        //1、转盘抽奖人数
        int drawUser = cashFlowMapper.countDrawUser(startTime, endTime);
        //2、统计对应时间段内新增用户
        Integer countRegUser = userIntegrationService.countRegUser(startTime, endTime);
        //3、新增赏金总额
        BigDecimal totalBounty = cashFlowMapper.totalBounty(startTime, endTime);
        //4、提现人数
        int countNumber = withdrawMapper.countNumber(startTime, endTime);
        //5、发起提现总金额
        BigDecimal totalAmount = withdrawMapper.countWithdrawAmount(startTime, endTime);
        //6、成功提现总金额
        BigDecimal successAmount = withdrawMapper.countSuccessWithdrawAmount(startTime, endTime);
        //7、公司账户余额
        Double companyAmount = redisStringAdapter.get(getCompanyAmountKey(), Double.class);

        return new MoneyChange(drawUser, countRegUser, totalBounty, countNumber, totalAmount, successAmount, companyAmount);
    }

    @Override
    public BigDecimal getCompanyAccount() {
        Double companyAmount = redisStringAdapter.get(getCompanyAmountKey(), Double.class);
        return BigDecimal.valueOf(companyAmount);
    }

    /**
     * 公司账户余额key
     *
     * @return
     */
    private KeyGenerator getCompanyAmountKey() {
        return RedisConfig.COMPANY_REMAIN_AMOUNT.copy().appendKey("balance");
    }
}
