package com.bxm.localnews.payment.timer;

import com.alibaba.fastjson.JSONObject;
import com.bxm.component.httpclient.service.HttpClientService;
import com.bxm.localnews.payment.config.WithdrawProperties;
import com.bxm.localnews.payment.service.MoneyChangeService;
import com.bxm.localnews.payment.vo.MoneyChange;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.bxm.newidea.component.tools.DateUtils;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Calendar;
import java.util.Date;

/**
 * 创建即发布的周期定时任务
 */
@Component
@Slf4j
public class CompanyAccountTask extends AbstractCronTask<String> {

    @Resource
    private WithdrawProperties withdrawProperties;

    @Resource
    private HttpClientService httpClientService;

    @Resource
    private MoneyChangeService moneyChangeService;

    @Override
    protected ReturnT<String> service(String param) {
        Date now = new Date();
        Date beforeNow = DateUtils.addField(now, Calendar.HOUR, -1);
        String startTime = DateUtils.formatDateHour(beforeNow);
        String endTime = DateUtils.formatDateHour(now);

        MoneyChange moneyChange = moneyChangeService.changeMoneyStatisticsByHour(startTime, endTime);
        StringBuilder content = new StringBuilder();
        content.append("------").append(beforeNow.getMonth() + 1).append("月").append(beforeNow.getDate())
                .append("日").append(beforeNow.getHours()).append("时").append("------\n");

        content.append("转盘抽奖人数：[").append(moneyChange.getDrawNumber()).append("]\n");
        content.append("注册人数：[").append(moneyChange.getCountRegUser()).append("]\n");
        content.append("新增赏金总额：[").append(moneyChange.getTotalBounty().setScale(2)).append("]\n");
        content.append("发起提现人数：[").append(moneyChange.getWithdrawNumber()).append("]\n");
        content.append("提现总金额：[").append(moneyChange.getWithdarawAmount().setScale(2)).append("]\n");
        content.append("成功提现金额：[").append(moneyChange.getSuccessWithdrawAmount().setScale(2)).append("]\n");
        content.append("公司账户余额：[").append(moneyChange.getCompanyAmount()).append("]");

        JSONObject text = new JSONObject();
        text.put("content", content);

        JSONObject msg = new JSONObject();
        msg.put("msgtype", "text");
        msg.put("text", text);

        String response = httpClientService.doPostJson(withdrawProperties.getRedPacketStatistics(), msg.toJSONString());
        log.debug("dingding response:{}", response);
        return ReturnT.SUCCESS;
    }

    @Override
    public String taskName() {
        return "companyAccountTask";
    }

    @Override
    public String cron() {
        return "0 1 0/1 * * ? *";
    }

    @Override
    public String description() {
        return "公司微信账户每小时相关信息统计";
    }

}
