package com.bxm.localnews.payment.withdraw;

import com.bxm.localnews.payment.withdraw.filter.BaseWithdrawFilter;
import com.bxm.localnews.payment.withdraw.filter.BindAccountWithdrawFilter;
import com.bxm.localnews.payment.withdraw.filter.ExistsOrderWithdrawFilter;
import com.bxm.localnews.payment.withdraw.filter.UpperLimitWithdrawFilter;
import com.google.common.collect.Maps;
import org.springframework.core.Ordered;

import java.util.Map;

/**
 * 过滤器排序的统一定义，防止混乱
 * @author liujia
 * @date 2020/05/18 21:37
 */
public class FilterOrder {
    private FilterOrder() {
    }

    private static Map<Class<? extends WithdrawFilter>, Integer> defindOrderMap;

    static {
        defindOrderMap = Maps.newHashMap();
        //定义过滤器顺序，数值越小越先执行
        int index = 0;

        //基础过滤器，优先级最高
        defindOrderMap.put(BaseWithdrawFilter.class, Ordered.HIGHEST_PRECEDENCE);

        //通用逻辑
        defindOrderMap.put(BindAccountWithdrawFilter.class, ++index);
        defindOrderMap.put(UpperLimitWithdrawFilter.class, ++index);
        defindOrderMap.put(ExistsOrderWithdrawFilter.class, ++index);
    }

    public static Integer getOrder(Class<? extends WithdrawFilter> clasz) {
        return defindOrderMap.getOrDefault(clasz, Integer.MAX_VALUE);
    }
}
