package com.bxm.localnews.payment.withdraw.strategy;

import com.bxm.localnews.payment.WithdrwaStrategyEnum;
import com.bxm.localnews.payment.withdraw.WithdrawContext;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.vo.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;

import static com.bxm.localnews.common.constant.RedisConfig.WITHDRAW_DAILY_ONCE_RECORD;
import static com.bxm.newidea.component.tools.DateUtils.PATTERN_NO_DELIMITER_FORMAT;

/**
 * 每日一次的提现，可以直接到账
 * @author liujia
 * @date 2020/05/19 17:32
 */
@Component
public class DailyOnceWithdrawStrategy extends AbstractWithdrawStrategy {

    private final RedisSetAdapter redisSetAdapter;

    @Autowired
    public DailyOnceWithdrawStrategy(RedisSetAdapter redisSetAdapter) {
        this.redisSetAdapter = redisSetAdapter;
    }

    @Override
    public WithdrwaStrategyEnum match() {
        return WithdrwaStrategyEnum.DAILY_ONCE;
    }

    @Override
    public Message execWithdraw(WithdrawContext context) {
        Message message = directWithdraw(context);

        if (message.isSuccess()) {
            redisSetAdapter.add(buildKey(context.getUserId()), context.getUserId());
        }

        return message;
    }

    private KeyGenerator buildKey(Long userId) {
        String today = PATTERN_NO_DELIMITER_FORMAT.get().format(new Date());
        return WITHDRAW_DAILY_ONCE_RECORD.copy().appendKey(today).appendKey(userId % 10);
    }

    @Override
    public boolean hasTimes(Long userId) {
        boolean exists = redisSetAdapter.exists(buildKey(userId), userId);
        return !exists;
    }
}
