/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.payment.config;

import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.CertAlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import com.bxm.localnews.payment.config.AlipayCertProperties;
import com.bxm.localnews.payment.config.AlipayProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration
@EnableConfigurationProperties(value={AlipayProperties.class})
public class AliPayConfiguration {
    private static final Logger log = LoggerFactory.getLogger(AliPayConfiguration.class);
    private final AlipayProperties alipayProperties;
    private final AlipayCertProperties alipayCertProperties;

    @Bean(value={"alipayClient"})
    public AlipayClient alipayClient() {
        DefaultAlipayClient alipayClient = new DefaultAlipayClient(this.alipayProperties.getGateWayUrl(), this.alipayProperties.getAppId(), this.alipayProperties.getRsaPrivateKey(), this.alipayProperties.getFormat(), this.alipayProperties.getCharset(), this.alipayProperties.getAlipayPublicKey(), this.alipayProperties.getSigntype());
        return alipayClient;
    }

    @Bean
    @Lazy
    public AlipayClient alipayCertClient() throws AlipayApiException {
        CertAlipayRequest certAlipayRequest = new CertAlipayRequest();
        certAlipayRequest.setServerUrl(this.alipayCertProperties.getGateWayUrl());
        certAlipayRequest.setAppId(this.alipayCertProperties.getAppId());
        certAlipayRequest.setPrivateKey(this.alipayCertProperties.getPrivateKey());
        certAlipayRequest.setFormat(this.alipayCertProperties.getFormat());
        certAlipayRequest.setCharset(this.alipayCertProperties.getCharset());
        certAlipayRequest.setSignType(this.alipayCertProperties.getSignType());
        certAlipayRequest.setCertPath(this.alipayCertProperties.getCertPath());
        certAlipayRequest.setAlipayPublicCertPath(this.alipayCertProperties.getAlipayPublicCertPath());
        certAlipayRequest.setRootCertPath(this.alipayCertProperties.getRootCertPath());
        try {
            return new DefaultAlipayClient(certAlipayRequest);
        }
        catch (Exception e) {
            log.error("\u521d\u59cb\u5316alipayCertClient\u5931\u8d25\u4f7f\u7528alipayClient()\u8fd4\u56de", (Throwable)e);
            return this.alipayClient();
        }
    }

    public AliPayConfiguration(AlipayProperties alipayProperties, AlipayCertProperties alipayCertProperties) {
        this.alipayProperties = alipayProperties;
        this.alipayCertProperties = alipayCertProperties;
    }
}

