/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.payment.config;

import com.bxm.localnews.base.service.BaseUrlFacadeService;
import com.bxm.localnews.payment.config.WxPayProperties;
import com.github.binarywang.wxpay.config.WxPayConfig;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.WxPayService;
import com.github.binarywang.wxpay.service.impl.WxPayServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={WxPayService.class})
@EnableConfigurationProperties(value={WxPayProperties.class})
public class WxPayConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(WxPayConfiguration.class);
    private WxPayProperties properties;
    private final BaseUrlFacadeService baseUrlFacadeService;

    @Bean
    public WxPayService wxPayService() {
        WxPayConfig payConfig = new WxPayConfig();
        payConfig.setAppId(StringUtils.trimToNull((String)this.properties.getAppId()));
        payConfig.setMchId(StringUtils.trimToNull((String)this.properties.getMchId()));
        payConfig.setMchKey(StringUtils.trimToNull((String)this.properties.getMchKey()));
        payConfig.setKeyPath(StringUtils.trimToNull((String)this.properties.getKeyPath()));
        payConfig.setNotifyUrl(StringUtils.trimToNull((String)StringUtils.join((Object[])new String[]{this.baseUrlFacadeService.getServerHostBaseUrl(), this.properties.getNotifyPath()})));
        payConfig.setTradeType(StringUtils.trimToNull((String)this.properties.getTradeType()));
        payConfig.setUseSandboxEnv(this.properties.getUseSandbox().booleanValue());
        WxPayServiceImpl wxPayService = new WxPayServiceImpl();
        wxPayService.setConfig(payConfig);
        if (this.properties.getUseSandbox().booleanValue()) {
            try {
                payConfig.setMchKey(wxPayService.getSandboxSignKey());
            }
            catch (WxPayException e) {
                logger.error("\u6c99\u7bb1\u73af\u5883\u5f00\u542f\u5931\u8d25\uff1a", (Throwable)e);
            }
        }
        return wxPayService;
    }

    @Bean
    public WxPayService wxWithdrawPayService() {
        WxPayConfig payConfig = new WxPayConfig();
        payConfig.setAppId(StringUtils.trimToNull((String)this.properties.getWithdrawAppId()));
        payConfig.setMchId(StringUtils.trimToNull((String)this.properties.getWithdrawMchId()));
        payConfig.setMchKey(StringUtils.trimToNull((String)this.properties.getWithdrawMchKey()));
        payConfig.setKeyPath(StringUtils.trimToNull((String)this.properties.getWithdrawKeyPath()));
        payConfig.setNotifyUrl(StringUtils.trimToNull((String)StringUtils.join((Object[])new String[]{this.baseUrlFacadeService.getServerHostBaseUrl(), this.properties.getNotifyPath()})));
        payConfig.setTradeType(StringUtils.trimToNull((String)this.properties.getWithdrawTradeType()));
        payConfig.setUseSandboxEnv(this.properties.getWithdrawUseSandbox().booleanValue());
        WxPayServiceImpl wxPayService = new WxPayServiceImpl();
        wxPayService.setConfig(payConfig);
        if (this.properties.getWithdrawUseSandbox().booleanValue()) {
            try {
                payConfig.setMchKey(wxPayService.getSandboxSignKey());
            }
            catch (WxPayException e) {
                logger.error("\u6c99\u7bb1\u73af\u5883\u5f00\u542f\u5931\u8d25\uff1a", (Throwable)e);
            }
        }
        return wxPayService;
    }

    @Bean
    public WxPayService wxAppletPayService() {
        WxPayConfig payConfig = new WxPayConfig();
        payConfig.setAppId(StringUtils.trimToNull((String)this.properties.getAppletAppId()));
        payConfig.setMchId(StringUtils.trimToNull((String)this.properties.getAppletMchId()));
        payConfig.setMchKey(StringUtils.trimToNull((String)this.properties.getAppletMchKey()));
        payConfig.setKeyPath(StringUtils.trimToNull((String)this.properties.getAppletKeyPath()));
        payConfig.setNotifyUrl(StringUtils.trimToNull((String)StringUtils.join((Object[])new String[]{this.baseUrlFacadeService.getServerHostBaseUrl(), this.properties.getNotifyPath()})));
        payConfig.setTradeType(StringUtils.trimToNull((String)this.properties.getAppletTradeType()));
        payConfig.setUseSandboxEnv(this.properties.getAppletUseSandbox().booleanValue());
        WxPayServiceImpl wxPayService = new WxPayServiceImpl();
        wxPayService.setConfig(payConfig);
        if (this.properties.getUseSandbox().booleanValue()) {
            try {
                payConfig.setMchKey(wxPayService.getSandboxSignKey());
            }
            catch (WxPayException e) {
                logger.error("\u6c99\u7bb1\u73af\u5883\u5f00\u542f\u5931\u8d25\uff1a", (Throwable)e);
            }
        }
        return wxPayService;
    }

    public WxPayConfiguration(WxPayProperties properties, BaseUrlFacadeService baseUrlFacadeService) {
        this.properties = properties;
        this.baseUrlFacadeService = baseUrlFacadeService;
    }
}

