/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.payment.order;

import com.bxm.localnews.payment.constant.OrderTypeEnum;
import com.bxm.localnews.payment.order.OrderProcesser;
import com.bxm.localnews.payment.order.impl.DefaultOrderProcesser;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OrderProcesserManager {
    private Map<String, OrderProcesser> processerMap;
    private OrderProcesser defaultProcesser = new DefaultOrderProcesser();

    @Autowired
    public OrderProcesserManager(List<OrderProcesser> processers) {
        this.processerMap = Maps.newHashMap();
        if (processers != null) {
            processers.forEach(item -> this.processerMap.put(item.match().getCode(), (OrderProcesser)item));
        }
    }

    public OrderProcesser get(String orderType) {
        OrderTypeEnum orderTypeEnum = OrderTypeEnum.getByCode((String)orderType);
        if (orderTypeEnum == null) {
            return this.defaultProcesser;
        }
        return this.processerMap.getOrDefault(orderType, this.defaultProcesser);
    }
}

