/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.payment.order;

import com.bxm.localnews.common.constant.RedisConfig;
import com.bxm.localnews.common.util.NidGeneratorUtil;
import com.bxm.localnews.facade.UserFeignService;
import com.bxm.localnews.integration.MerchantIntegrationService;
import com.bxm.localnews.payment.config.PayProperties;
import com.bxm.localnews.payment.constant.OrderTypeEnum;
import com.bxm.localnews.payment.constant.PayTypeEnum;
import com.bxm.localnews.payment.constant.PaymentStatusEnum;
import com.bxm.localnews.payment.domain.PaymentOrderMapper;
import com.bxm.localnews.payment.dto.PaymentOrderDTO;
import com.bxm.localnews.payment.order.OrderProcesser;
import com.bxm.localnews.payment.order.OrderProcesserManager;
import com.bxm.localnews.payment.param.PayRefundParam;
import com.bxm.localnews.payment.param.PaymentRefundParam;
import com.bxm.localnews.payment.param.RefundParam;
import com.bxm.localnews.payment.param.UserOrderFacadeParam;
import com.bxm.localnews.payment.param.UserOrderParam;
import com.bxm.localnews.payment.pay.PayProxyService;
import com.bxm.localnews.payment.vo.PaymentOrder;
import com.bxm.localnews.payment.vo.PaymentOrderDetail;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.Message;
import com.gexin.fastjson.JSON;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional(rollbackFor={Exception.class})
public class PaymentOrderFactory {
    private static final Logger log = LoggerFactory.getLogger(PaymentOrderFactory.class);
    private final OrderProcesserManager orderProcesserManager;
    private final PayProxyService payProxyService;
    private final PaymentOrderMapper paymentOrderMapper;
    private final SequenceCreater sequenceCreater;
    private final RedisStringAdapter redisStringAdapter;
    private final UserFeignService userFeignService;
    private final MerchantIntegrationService merchantIntegrationService;
    private final PayProperties payProperties;
    private static final long CACHE_EXPIRED_SECONDS = 21600L;
    private static final BigDecimal DEFAULT_WITHDRQAW = BigDecimal.valueOf(0.01);

    public PaymentOrderDTO build(UserOrderParam param) {
        OrderProcesser processer = this.orderProcesserManager.get(param.getOrderType());
        Message message = processer.preCheck(param);
        if (message.isSuccess()) {
            this.fixConflictOrder(param);
            PaymentOrder order = this.createOrder(param, processer);
            PaymentOrderDetail orderDetail = new PaymentOrderDetail();
            BeanUtils.copyProperties((Object)order, (Object)orderDetail);
            orderDetail.setAuthCode(param.getWechatCode());
            orderDetail.setReturnUrl(param.getReturnUrl());
            this.payProxyService.create(orderDetail);
            this.paymentOrderMapper.insertSelective(order);
            this.saveOrderCache(order);
            if (com.bxm.newidea.component.tools.StringUtils.isNotEmpty((CharSequence)param.getInviterId()) && Objects.equals(param.getOrderType(), OrderTypeEnum.WELFARE_VIP.getCode())) {
                this.userFeignService.bindInviteUserId(param.getUserId(), Long.valueOf(Long.parseLong(param.getInviterId().trim())));
            }
            PaymentOrderDTO paymentOrderDTO = new PaymentOrderDTO(orderDetail.getLink(), order.getPaymentNum());
            BeanUtils.copyProperties((Object)orderDetail, (Object)paymentOrderDTO);
            return paymentOrderDTO;
        }
        log.warn("\u7528\u6237: {} \u4e0b\u5355\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570: {} \u9519\u8bef\u4fe1\u606f: {}", new Object[]{param.getUserId(), JSON.toJSON((Object)param), message.getLastMessage()});
        return null;
    }

    public PaymentOrderDTO build(UserOrderFacadeParam param) {
        UserOrderParam orderParam = new UserOrderParam();
        BeanUtils.copyProperties((Object)param, (Object)orderParam);
        return this.build(orderParam);
    }

    private void saveOrderCache(PaymentOrder order) {
        KeyGenerator key = RedisConfig.WEIXIN_ORDER_STATUS.copy().appendKey((Object)order.getPaymentNum());
        this.redisStringAdapter.set(key, (Object)order.getStatus(), 21600L);
    }

    private String generatePaymentNum(Byte payType) {
        String prefix = PayTypeEnum.getNameByType((Byte)payType);
        return NidGeneratorUtil.getOrderNo((String)prefix);
    }

    private PaymentOrder createOrder(UserOrderParam param, OrderProcesser processer) {
        Date now = new Date();
        String paymentNum = this.generatePaymentNum(param.getPayType());
        PaymentOrder paymentOrder = new PaymentOrder();
        paymentOrder.setId(this.sequenceCreater.nextLongId());
        paymentOrder.setPaymentNum(paymentNum);
        paymentOrder.setStatus(PaymentStatusEnum.WAIT.getType());
        if (param.getAmount() == null) {
            paymentOrder.setAmount(processer.price(param));
        } else if (Objects.equals(this.payProperties.getPriceMockSwitch(), Boolean.TRUE)) {
            log.info("\u6d4b\u8bd5\u6362\u5c06\u521b\u5efa\u8ba2\u5355\uff0c\u63a5mock, \u539f\u4ef7: {} \u4fee\u6539\u73b0\u4ef7: {}", (Object)param.getAmount(), (Object)DEFAULT_WITHDRQAW);
            paymentOrder.setAmount(DEFAULT_WITHDRQAW);
        } else {
            paymentOrder.setAmount(param.getAmount());
        }
        String paymentTitle = Objects.equals(param.getOrderType(), OrderTypeEnum.USER_BUY_GOODS.getCode()) || Objects.equals(param.getOrderType(), OrderTypeEnum.MERCHANT_VIP.getCode()) ? param.getPaymentTitle() : this.payProperties.getDefaultPaymentTitle();
        paymentOrder.setPayType(param.getPayType());
        paymentOrder.setUserId(param.getUserId());
        paymentOrder.setBizId(param.getBizId());
        paymentOrder.setStartTime(now);
        paymentOrder.setCreateTime(now);
        paymentOrder.setClientIp(param.getRequestIp());
        paymentOrder.setChannel(param.getChnl());
        paymentOrder.setOrderType(processer.match().getCode());
        paymentOrder.setOrderSn(param.getOrderSn());
        paymentOrder.setPlatform(Integer.valueOf(param.getPlatform()));
        paymentOrder.setPaymentTitle(paymentTitle);
        return paymentOrder;
    }

    private void fixConflictOrder(UserOrderParam param) {
        PaymentOrder paymentOrder = this.paymentOrderMapper.getUserPaymentOrderByStatus(param.getUserId(), PaymentStatusEnum.WAIT.getType(), param.getOrderType());
        if (paymentOrder == null) {
            return;
        }
        paymentOrder.setStatus(PaymentStatusEnum.UNDO.getType());
        this.paymentOrderMapper.updateByPrimaryKey(paymentOrder);
    }

    public Message submitRefund(PayRefundParam payRefundParam) {
        if (null == payRefundParam || null == payRefundParam.getOrderId()) {
            return Message.build((boolean)false);
        }
        PaymentOrder paymentOrder = this.paymentOrderMapper.queryByOrderId(payRefundParam.getOrderId());
        if (paymentOrder == null) {
            log.info("\u63d0\u4ea4\u9000\u6b3e\u7533\u8bf7\u5931\u8d25\uff0c\u8ba2\u5355\u4e0d\u5b58\u5728\uff0c\u8ba2\u5355id\uff1a{}", (Object)paymentOrder.getId());
            return Message.build((boolean)false, (String)("\u8ba2\u5355\u4e0d\u5b58\u5728\uff0c\u8ba2\u5355id\u4e3a\uff1a" + paymentOrder.getId()));
        }
        if (!Objects.equals(PaymentStatusEnum.SUCCEED.getType(), paymentOrder.getStatus()) && !Objects.equals(PaymentStatusEnum.REFUND_FAIL.getType(), paymentOrder.getStatus())) {
            log.info("\u63d0\u4ea4\u9000\u6b3e\u7533\u8bf7\u5931\u8d25\uff0c\u8ba2\u5355id\uff1a{}", (Object)paymentOrder.getId());
            return Message.build((boolean)false, (String)"\u5f53\u524d\u8ba2\u5355\u72b6\u6001\u4e0d\u5141\u8bb8\u9000\u6b3e");
        }
        PaymentRefundParam paymentRefundParam = new PaymentRefundParam();
        paymentRefundParam.setPayOrder(paymentOrder);
        paymentRefundParam.setFullAmount(Boolean.valueOf(true));
        return this.payProxyService.submitRefund(paymentRefundParam);
    }

    public Message submitRefund(RefundParam param) {
        if (Objects.isNull(param) || StringUtils.isBlank((CharSequence)param.getPaymentNum())) {
            return Message.build((boolean)false);
        }
        PaymentOrder paymentOrder = this.paymentOrderMapper.queryByNo(param.getPaymentNum());
        if (Objects.isNull(paymentOrder)) {
            log.warn("\u652f\u4ed8\u6d41\u6c34\u4e0d\u5b58\u5728\uff0c\u6d41\u6c34\u5355\u53f7\u4e3a\uff1a{}", (Object)param.getPaymentNum());
            return Message.build((boolean)false, (String)("\u652f\u4ed8\u6d41\u6c34\u4e0d\u5b58\u5728 \u6d41\u6c34\u5355\u53f7\u4e3a\uff1a" + param.getPaymentNum()));
        }
        if (!Objects.equals(PaymentStatusEnum.SUCCEED.getType(), paymentOrder.getStatus()) && !Objects.equals(PaymentStatusEnum.REFUND_FAIL.getType(), paymentOrder.getStatus())) {
            log.warn("\u63d0\u4ea4\u9000\u6b3e\u7533\u8bf7\u5931\u8d25\uff0c\u5f53\u524d\u72b6\u6001: {} \u4e0d\u5141\u8bb8\u9000\u6b3e\uff0c\u652f\u4ed8\u6d41\u6c34\uff1a{}", (Object)paymentOrder.getStatus(), (Object)param.getPaymentNum());
            return Message.build((boolean)false, (String)"\u5f53\u524d\u8ba2\u5355\u72b6\u6001\u4e0d\u5141\u8bb8\u9000\u6b3e");
        }
        PaymentRefundParam paymentRefundParam = new PaymentRefundParam();
        paymentRefundParam.setPayOrder(paymentOrder);
        paymentRefundParam.setFullAmount(Boolean.valueOf(Objects.equals(param.getFullAmount(), Boolean.TRUE)));
        paymentRefundParam.setRefundFee(param.getRefundFee());
        return this.payProxyService.submitRefund(paymentRefundParam);
    }

    public String execRefundCallback(String request, PayTypeEnum payType) {
        return this.payProxyService.execRefundCallback(request, payType);
    }

    public PaymentOrderFactory(OrderProcesserManager orderProcesserManager, PayProxyService payProxyService, PaymentOrderMapper paymentOrderMapper, SequenceCreater sequenceCreater, RedisStringAdapter redisStringAdapter, UserFeignService userFeignService, MerchantIntegrationService merchantIntegrationService, PayProperties payProperties) {
        this.orderProcesserManager = orderProcesserManager;
        this.payProxyService = payProxyService;
        this.paymentOrderMapper = paymentOrderMapper;
        this.sequenceCreater = sequenceCreater;
        this.redisStringAdapter = redisStringAdapter;
        this.userFeignService = userFeignService;
        this.merchantIntegrationService = merchantIntegrationService;
        this.payProperties = payProperties;
    }
}

