/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.payment.order.impl;

import com.bxm.localnews.activity.service.RedPacketFacadeService;
import com.bxm.localnews.payment.constant.OrderTypeEnum;
import com.bxm.localnews.payment.order.OrderProcesser;
import com.bxm.localnews.payment.param.UserOrderParam;
import com.bxm.localnews.payment.vo.PaymentOrder;
import com.bxm.newidea.component.vo.Message;
import java.math.BigDecimal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RedPacketOrderProcesser
implements OrderProcesser {
    private final RedPacketFacadeService redPacketFacadeService;

    @Autowired
    public RedPacketOrderProcesser(RedPacketFacadeService redPacketFacadeService) {
        this.redPacketFacadeService = redPacketFacadeService;
    }

    @Override
    public OrderTypeEnum match() {
        return OrderTypeEnum.RED_PACKET;
    }

    @Override
    public Message preCheck(UserOrderParam param) {
        return null;
    }

    @Override
    public BigDecimal price(UserOrderParam param) {
        return BigDecimal.ZERO;
    }

    @Override
    public Message afterPayment(PaymentOrder paymentOrder) {
        this.redPacketFacadeService.updateRedpacketActiveStatus(paymentOrder.getBizId(), paymentOrder.getPaymentNum(), Integer.valueOf(1));
        return Message.build();
    }

    @Override
    public Message afterRefund(PaymentOrder paymentOrder) {
        return null;
    }
}

