/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.payment.pay.impl;

import com.bxm.localnews.payment.constant.PaymentStatusEnum;
import com.bxm.localnews.payment.domain.PaymentOrderMapper;
import com.bxm.localnews.payment.domain.UserPayorderRefundMapper;
import com.bxm.localnews.payment.dto.NotifyContext;
import com.bxm.localnews.payment.dto.PayCallBackResult;
import com.bxm.localnews.payment.param.PaymentRefundParam;
import com.bxm.localnews.payment.param.UserPayorderRefundBean;
import com.bxm.localnews.payment.pay.PayModeService;
import com.bxm.localnews.payment.pay.PaymentOrderService;
import com.bxm.localnews.payment.pay.callback.listener.CallbackNotifier;
import com.bxm.localnews.payment.vo.PaymentOrder;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.gexin.fastjson.JSON;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractPayModeService
implements PayModeService {
    private static final Logger log = LoggerFactory.getLogger(AbstractPayModeService.class);
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private PaymentOrderMapper paymentOrderMapper;
    @Autowired
    private UserPayorderRefundMapper userPayorderRefundMapper;
    @Autowired
    protected PaymentOrderService payService;
    @Resource
    private SequenceCreater sequenceCreater;
    @Autowired
    private CallbackNotifier callbackNotifier;

    protected void changeRefundOrderStatus(String refundOrderNo, String refundTradeNo, String result, PaymentStatusEnum status) {
        this.userPayorderRefundMapper.updateByOrderNo(UserPayorderRefundBean.builder().refundOrderNo(refundOrderNo).refundTradeNo(refundTradeNo).result(result).status(status.getType()).build());
        this.paymentOrderMapper.updateRefundOrder(refundTradeNo, status.getType());
    }

    protected void createRefundOrder(PaymentRefundParam param, String refundOrderNo, BigDecimal refundFee) {
        UserPayorderRefundBean history = this.userPayorderRefundMapper.selectByOrderNo(refundOrderNo);
        UserPayorderRefundBean refundBean = UserPayorderRefundBean.builder().id(this.sequenceCreater.nextLongId()).createTime(new Date()).operatorId(param.getOperatorId()).orderId(param.getPayOrder().getId()).refundOrderNo(refundOrderNo).refundFee(refundFee).remark(param.getRemark()).status(PaymentStatusEnum.REFUNDING.getType()).build();
        if (null != history) {
            refundBean.setId(history.getId());
            refundBean.setResult("");
            refundBean.setCreateTime(null);
            this.userPayorderRefundMapper.updateByPrimaryKeySelective(refundBean);
        } else {
            this.userPayorderRefundMapper.insert(refundBean);
        }
        this.paymentOrderMapper.updateRefundOrder(param.getPayOrder().getPaymentNum(), PaymentStatusEnum.REFUNDING.getType());
    }

    protected String buildRefundOrderNo(PaymentRefundParam param) {
        return "R" + param.getPayOrder().getPaymentNum();
    }

    @Override
    public String callBack(String data) {
        if (StringUtils.isBlank((CharSequence)data)) {
            return null;
        }
        PayCallBackResult callBackResult = this.doCallBack(data);
        if (Objects.nonNull(callBackResult) && callBackResult.isCallBackSuccess()) {
            this.callbackNotify(true, callBackResult.getPaymentOrder(), data);
            return callBackResult.getData();
        }
        this.callbackNotify(false, null, data);
        return null;
    }

    private void callbackNotify(boolean callBackSuccess, PaymentOrder paymentOrder, String callbackData) {
        NotifyContext context = new NotifyContext();
        context.setCallBackSuccess(callBackSuccess);
        context.setCallbackData(callbackData);
        context.setOrder(paymentOrder);
        try {
            this.callbackNotifier.callbackNotifyAll(context);
        }
        catch (Exception e) {
            log.error("\u652f\u4ed8\u56de\u8c03\u5904\u7406\u540e\u901a\u77e5\u5931\u8d25, context: {}", (Object)JSON.toJSONString((Object)context), (Object)e);
        }
    }

    protected abstract PayCallBackResult doCallBack(String var1);

    protected PayCallBackResult buildSuccessResult(String data, PaymentOrder paymentOrder) {
        return PayCallBackResult.builder().callBackSuccess(true).data(data).paymentOrder(paymentOrder).build();
    }

    protected PayCallBackResult buildFailedResult() {
        return PayCallBackResult.builder().callBackSuccess(false).build();
    }
}

