/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.payment.service.impl;

import com.bxm.localnews.msg.integration.SmsIntegrationService;
import com.bxm.localnews.payment.constant.RedisLockKey;
import com.bxm.localnews.payment.domain.PaymentWithdrawAccountExtendMapper;
import com.bxm.localnews.payment.entity.PaymentWithdrawAccount;
import com.bxm.localnews.payment.param.AlipayAccountBindingParam;
import com.bxm.localnews.payment.service.PaymentWithdrawAccountService;
import com.bxm.localnews.payment.vo.WithdrawAccountVO;
import com.bxm.newidea.component.redis.DistributedLock;
import com.bxm.newidea.component.uuid.SequenceCreater;
import com.bxm.newidea.component.vo.Message;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PaymentWithdrawAccountServiceImpl
implements PaymentWithdrawAccountService {
    private static final Logger log = LoggerFactory.getLogger(PaymentWithdrawAccountServiceImpl.class);
    private final PaymentWithdrawAccountExtendMapper paymentWithdrawAccountExtendMapper;
    private final DistributedLock lock;
    private final SequenceCreater sequenceCreater;
    private final SmsIntegrationService smsIntegrationService;
    private static final Pattern ALU_PAY_ACCOUNT_REG = Pattern.compile("^(?:1[3-9]\\d{9}|[a-zA-Z\\d._-]*\\@[a-zA-Z\\d.-]{1,10}\\.[a-zA-Z\\d]{1,20})$");

    @Override
    public Message bindOrUpdateAlipayAccount(AlipayAccountBindingParam param) {
        String lockId;
        String lockKey = RedisLockKey.BIND_WITHDRAW_ACCOUNT.copy().appendKey((Object)Objects.toString(param.getUserId())).gen();
        if (!this.lock.lock(lockKey, lockId = this.sequenceCreater.nextStringId())) {
            return Message.build((boolean)false).setMessage("\u8bf7\u52ff\u9891\u7e41\u63d0\u4ea4");
        }
        if (!Objects.equals(this.smsIntegrationService.verifyByType(Byte.valueOf((byte)8), param.getPhone(), param.getSmsCode()), Boolean.TRUE)) {
            return Message.build((boolean)false).setMessage("\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        Matcher m = ALU_PAY_ACCOUNT_REG.matcher(param.getAccount());
        if (!m.matches()) {
            return Message.build((boolean)false).setMessage("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u652f\u4ed8\u5b9d\u8d26\u53f7");
        }
        Date now = new Date();
        List accounts = this.paymentWithdrawAccountExtendMapper.selectByUserIdAndType(param.getUserId(), Byte.valueOf((byte)1));
        if (!CollectionUtils.isEmpty((Collection)accounts)) {
            if (accounts.size() > 1) {
                log.warn("\u7528\u6237: {} \u7684\u63d0\u73b0\u8d26\u53f7\u7c7b\u578b: {} \u6709: {} \u4e2a\u8d26\u53f7\uff0c\u53ea\u66f4\u65b0\u6700\u540e\u4e00\u4e2a", new Object[]{param.getUserId(), (byte)1, accounts.size()});
            }
            PaymentWithdrawAccount account = (PaymentWithdrawAccount)accounts.get(accounts.size() - 1);
            PaymentWithdrawAccount update = new PaymentWithdrawAccount();
            update.setId(account.getId());
            update.setAccount(param.getAccount());
            update.setRealName(param.getRealName());
            update.setModifyTime(now);
            this.paymentWithdrawAccountExtendMapper.updateByPrimaryKeySelective(update);
        } else {
            PaymentWithdrawAccount create = new PaymentWithdrawAccount();
            create.setId(this.sequenceCreater.nextLongId());
            create.setUserId(param.getUserId());
            create.setType(Byte.valueOf((byte)1));
            create.setAccount(param.getAccount());
            create.setRealName(param.getRealName());
            create.setCreateTime(now);
            create.setModifyTime(now);
            this.paymentWithdrawAccountExtendMapper.insertSelective(create);
        }
        this.lock.unlock(lockKey, lockId);
        return Message.build();
    }

    @Override
    public Optional<WithdrawAccountVO> getPaymentAccount(Byte type, Long userId) {
        List accounts = this.paymentWithdrawAccountExtendMapper.selectByUserIdAndType(userId, type);
        if (CollectionUtils.isEmpty((Collection)accounts)) {
            return Optional.empty();
        }
        return Optional.of(this.convert((PaymentWithdrawAccount)accounts.get(accounts.size() - 1)));
    }

    private WithdrawAccountVO convert(PaymentWithdrawAccount account) {
        WithdrawAccountVO accountVO = new WithdrawAccountVO();
        accountVO.setId(account.getId());
        accountVO.setUserId(account.getUserId());
        accountVO.setType(account.getType());
        accountVO.setAccount(account.getAccount());
        accountVO.setRealName(account.getRealName());
        return accountVO;
    }

    public PaymentWithdrawAccountServiceImpl(PaymentWithdrawAccountExtendMapper paymentWithdrawAccountExtendMapper, DistributedLock lock, SequenceCreater sequenceCreater, SmsIntegrationService smsIntegrationService) {
        this.paymentWithdrawAccountExtendMapper = paymentWithdrawAccountExtendMapper;
        this.lock = lock;
        this.sequenceCreater = sequenceCreater;
        this.smsIntegrationService = smsIntegrationService;
    }
}

