/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.payment.withdraw.filter;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.integration.UserAccountIntegrationService;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.payment.WithdrwaStrategyEnum;
import com.bxm.localnews.payment.dto.WithdrawOptionDTO;
import com.bxm.localnews.payment.withdraw.WithdrawContext;
import com.bxm.localnews.payment.withdraw.filter.AbstractWithdrawFilter;
import com.bxm.newidea.component.vo.Message;
import java.math.BigDecimal;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BaseWithdrawFilter
extends AbstractWithdrawFilter {
    private static final Logger log = LoggerFactory.getLogger(BaseWithdrawFilter.class);
    private final UserAccountIntegrationService userAccountIntegrationService;
    private final UserIntegrationService userIntegrationService;

    @Autowired
    public BaseWithdrawFilter(UserAccountIntegrationService userAccountIntegrationService, UserIntegrationService userIntegrationService) {
        this.userAccountIntegrationService = userAccountIntegrationService;
        this.userIntegrationService = userIntegrationService;
    }

    @Override
    public Message run(WithdrawContext context) {
        if (!this.withdrawProperties.getEnableSwitch().booleanValue()) {
            log.info("\u63d0\u73b0\u5f00\u5173\u672a\u5f00\u542f---\u4e0d\u5141\u8bb8\u63d0\u73b0");
            return Message.build((boolean)false, (String)"\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        context.setRisk(this.userIntegrationService.isRiskUser(context.getUserId()));
        this.setOption(context);
        if (context.getAmount().equals(BigDecimal.ZERO)) {
            log.error("\u7528\u6237\u53d1\u8d77\u7684\u63d0\u73b0\u91d1\u989d\u4e0d\u5728\u63d0\u73b0\u5217\u8868\u4e2d\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)context));
            return Message.build((boolean)false, (String)"\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        BigDecimal drawableCash = this.userAccountIntegrationService.getUserDrawableCash(context.getUserId());
        if (drawableCash.compareTo(context.getAmount()) < 0) {
            log.error("\u7528\u6237[{}]\u7684\u8d26\u6237\u4f59\u989d\u4e3a\uff1a[{}]\uff0c\u5c0f\u4e8e\u63d0\u73b0\u91d1\u989d[{}],\u4e0d\u5141\u8bb8\u63d0\u73b0", new Object[]{context.getUserId(), drawableCash, context.getAmount()});
            return Message.build((boolean)false, (String)"\u4f60\u7684\u8d26\u6237\u4f59\u989d\u4e0d\u8db3");
        }
        return Message.build();
    }

    private void setOption(WithdrawContext context) {
        for (WithdrawOptionDTO withdrawOption : this.withdrawProperties.getWithdrawOptions()) {
            if (Objects.equals(context.getOriginParam().getWithdrawId(), withdrawOption.getWithdrawId())) {
                context.setWithdrawOption(withdrawOption);
                return;
            }
            if (withdrawOption.getAmount().compareTo(context.getAmount()) != 0) continue;
            context.setWithdrawOption(withdrawOption);
            return;
        }
        if (!context.isRisk()) {
            BigDecimal limitAmount = new BigDecimal("2");
            if (context.getAmount().compareTo(limitAmount) < 1) {
                WithdrawOptionDTO option = new WithdrawOptionDTO();
                option.setAmount(context.getAmount());
                option.setStargy(WithdrwaStrategyEnum.DAILY_ONCE.name());
                context.setWithdrawOption(option);
                return;
            }
        }
        if (context.getAmount() != null && context.getWithdrawOption() == null) {
            WithdrawOptionDTO option = new WithdrawOptionDTO();
            option.setAmount(context.getAmount());
            option.setStargy(WithdrwaStrategyEnum.NORMAL.name());
            context.setWithdrawOption(option);
        }
    }
}

