/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.payment.withdraw.filter;

import com.bxm.localnews.integration.UserAuthIntegrationService;
import com.bxm.localnews.payment.constant.WithdrawTypeEnum;
import com.bxm.localnews.payment.service.PaymentWithdrawAccountService;
import com.bxm.localnews.payment.vo.WithdrawAccountVO;
import com.bxm.localnews.payment.withdraw.WithdrawContext;
import com.bxm.localnews.payment.withdraw.filter.AbstractWithdrawFilter;
import com.bxm.localnews.vo.UserAuth;
import com.bxm.newidea.component.vo.Message;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BindAccountWithdrawFilter
extends AbstractWithdrawFilter {
    private static final Logger log = LoggerFactory.getLogger(BindAccountWithdrawFilter.class);
    private final UserAuthIntegrationService userAuthIntegrationService;
    private final PaymentWithdrawAccountService paymentWithdrawAccountService;

    @Override
    public Message run(WithdrawContext context) {
        if (StringUtils.isBlank((CharSequence)context.getWithdrawAccount())) {
            if (StringUtils.isBlank((CharSequence)context.getOriginParam().getCurVer()) || com.bxm.newidea.component.tools.StringUtils.isLessThan((String)context.getOriginParam().getCurVer(), (String)"3.5.0")) {
                log.info("\u7528\u6237: {}\u5c5e\u4e8e\u4f4e\u7248\u672c\uff0c\u4f7f\u7528\u5fae\u4fe1\u63d0\u73b0", (Object)context.getUserId());
                context.setWithdrawType(WithdrawTypeEnum.WX_WITHDRAW);
                return this.setWechatWithdrawAccountInfo(context);
            }
            if (Objects.equals(context.getWithdrawType(), WithdrawTypeEnum.ALI_WITHDRAW)) {
                return this.setAliPayWithdrawAccountInfo(context);
            }
            if (Objects.equals(context.getWithdrawType(), WithdrawTypeEnum.WX_WITHDRAW)) {
                return this.setWechatWithdrawAccountInfo(context);
            }
            return Message.build((boolean)false, (String)"\u4e0d\u652f\u6301\u7684\u63d0\u73b0\u65b9\u5f0f");
        }
        return Message.build();
    }

    private Message setWechatWithdrawAccountInfo(WithdrawContext context) {
        UserAuth userAuth = this.userAuthIntegrationService.selectUserAuthByUserId(context.getUserId());
        if (userAuth == null) {
            log.warn("\u7528\u6237[{}]\u672a\u7ed1\u5b9aopenId, \u4e0d\u5141\u8bb8\u63d0\u73b0", (Object)context.getUserId());
            return Message.build((boolean)false, (String)"\u8bf7\u91cd\u65b0\u767b\u9646\u540e\u518d\u5c1d\u8bd5\u63d0\u73b0");
        }
        context.setWithdrawAccount(userAuth.getIdentifier());
        return Message.build();
    }

    private Message setAliPayWithdrawAccountInfo(WithdrawContext context) {
        Optional<WithdrawAccountVO> paymentAccount = this.paymentWithdrawAccountService.getPaymentAccount((byte)1, context.getUserId());
        if (!paymentAccount.isPresent()) {
            log.warn("\u7528\u6237[{}]\u9009\u62e9\u652f\u4ed8\u5b9d\u63d0\u73b0\uff0c\u4f46\u662f\u672a\u7ed1\u5b9a\u652f\u4ed8\u5b9d, \u4e0d\u5141\u8bb8\u63d0\u73b0", (Object)context.getUserId());
            return Message.build((boolean)false, (String)"\u8bf7\u5148\u7ed1\u5b9a\u652f\u4ed8\u5b9d");
        }
        if (StringUtils.isBlank((CharSequence)paymentAccount.get().getAccount())) {
            log.warn("\u7528\u6237[{}]\u9009\u62e9\u652f\u4ed8\u5b9d\u63d0\u73b0\uff0c\u4f46\u652f\u4ed8\u5b9d\u8d26\u53f7\u4e3a\u7a7a, \u4e0d\u5141\u8bb8\u63d0\u73b0", (Object)context.getUserId());
            return Message.build((boolean)false, (String)"\u8bf7\u5148\u7ed1\u5b9a\u652f\u4ed8\u5b9d");
        }
        if (StringUtils.isBlank((CharSequence)paymentAccount.get().getRealName())) {
            log.warn("\u7528\u6237[{}]\u9009\u62e9\u652f\u4ed8\u5b9d\u63d0\u73b0\uff0c\u4f46\u771f\u5b9e\u59d3\u540d\u4e3a\u7a7a, \u4e0d\u5141\u8bb8\u63d0\u73b0", (Object)context.getUserId());
            return Message.build((boolean)false, (String)"\u8bf7\u586b\u5199\u652f\u4ed8\u5b9d\u8d26\u6237\u5bf9\u5e94\u7684\u771f\u5b9e\u59d3\u540d");
        }
        context.setWithdrawAccount(paymentAccount.get().getAccount());
        context.setRealName(paymentAccount.get().getRealName());
        return Message.build();
    }

    public BindAccountWithdrawFilter(UserAuthIntegrationService userAuthIntegrationService, PaymentWithdrawAccountService paymentWithdrawAccountService) {
        this.userAuthIntegrationService = userAuthIntegrationService;
        this.paymentWithdrawAccountService = paymentWithdrawAccountService;
    }
}

